/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features;

import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PokeChestFeature
extends Feature<NoneFeatureConfiguration> {
    private static int lastChunk = 0;
    private static int lastX;
    private static int lastZ;
    private static int totalPlaced;
    private static int normalPlaced;
    private static int ultraPlaced;

    public PokeChestFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (NoneFeatureConfiguration)context.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, NoneFeatureConfiguration config) {
        if (UltraSpace.is((LevelReader)world)) {
            return false;
        }
        if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnNormal() || PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnHidden()) {
            this.genBlocks(rand, pos.m_123341_() >> 4, pos.m_123343_() >> 4, world);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void genBlocks(RandomSource random, int chunkX, int chunkZ, WorldGenLevel world) {
        int x = random.m_188503_(16) + chunkX * 16;
        int z = random.m_188503_(16) + chunkZ * 16;
        int y = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, new BlockPos(x, 0, z)).m_123342_();
        int distance = (int)Math.sqrt(Math.pow(lastX - x, 2.0) + Math.pow(lastZ - z, 2.0));
        if (distance >= PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnRate().getMinDistance() && lastChunk % PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnRate().getMinChunk() == 0) {
            BlockState underBlockState = world.m_8055_(new BlockPos(x, y - 1, z));
            while (underBlockState.m_204336_(BlockTags.f_13035_) || underBlockState.m_204336_(BlockTags.f_13106_) || underBlockState.m_60795_()) {
                if (--y <= 0) {
                    return;
                }
                underBlockState = world.m_8055_(new BlockPos(x, y - 1, z));
            }
            if (!underBlockState.m_60713_(Blocks.f_49991_) && !underBlockState.m_60713_(Blocks.f_49990_)) {
                Block block = PixelmonBlocks.poke_chest;
                if (normalPlaced > 4) {
                    if (ultraPlaced > 4) {
                        block = PixelmonBlocks.master_chest;
                        ultraPlaced = 0;
                    } else {
                        block = PixelmonBlocks.ultra_chest;
                        ++ultraPlaced;
                    }
                    normalPlaced = 0;
                } else {
                    ++normalPlaced;
                }
                BlockPos currentPos = new BlockPos(x, y, z);
                if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnHidden() && totalPlaced % PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnRate().getHiddenFrequency() == 0 && totalPlaced != 0 && block == PixelmonBlocks.poke_chest) {
                    world.m_7731_(currentPos, PixelmonBlocks.poke_chest.m_49966_(), 18);
                    chestEntity = world.m_7702_(currentPos);
                    if (!(chestEntity instanceof PokeChestTileEntity)) return;
                    ((PokeChestTileEntity)chestEntity).setVisibility(EnumPokechestVisibility.Hidden);
                } else if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnNormal()) {
                    world.m_7731_(currentPos, block.m_49966_(), 18);
                } else if (PixelmonConfigProxy.getSpawning().getPokeLoot().isSpawnHidden()) {
                    world.m_7731_(currentPos, PixelmonBlocks.poke_chest.m_49966_(), 18);
                    chestEntity = world.m_7702_(currentPos);
                    if (chestEntity instanceof PokeChestTileEntity) {
                        ((PokeChestTileEntity)chestEntity).setVisibility(EnumPokechestVisibility.Hidden);
                    }
                }
                BlockEntity t0 = world.m_7702_(currentPos);
                if (t0 instanceof PokeChestTileEntity) {
                    PokeChestTileEntity t = (PokeChestTileEntity)t0;
                    t.setChestOneTime(PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnMode().isOneTimeUse());
                    t.setDropOneTime(PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnMode().isOncePerPlayer());
                    t.setTimeEnabled(PixelmonConfigProxy.getSpawning().getPokeLoot().getSpawnMode().isTimeEnabled());
                    lastX = x;
                    lastZ = z;
                    ++totalPlaced;
                } else {
                    world.m_7471_(currentPos, false);
                }
            } else {
                --lastChunk;
            }
        }
        ++lastChunk;
    }

    static {
        lastZ = 0;
        totalPlaced = 0;
        normalPlaced = 0;
        ultraPlaced = 0;
    }
}

