/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.ultraspace.tree;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.world.generation.TrunkRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class GingkoFancyTrunkPlacer
extends TrunkPlacer {
    public static final Codec<GingkoFancyTrunkPlacer> CODEC = RecordCodecBuilder.create(p_236891_0_ -> GingkoFancyTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_236891_0_).apply((Applicative)p_236891_0_, GingkoFancyTrunkPlacer::new));

    public GingkoFancyTrunkPlacer(int p_i232054_1_, int p_i232054_2_, int p_i232054_3_) {
        super(p_i232054_1_, p_i232054_2_, p_i232054_3_);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TrunkRegistration.GINGKO.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> setter, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        int j1;
        int i = 5;
        int j = height + 2;
        int k = Mth.m_14107_((double)((double)j * 0.618));
        if (!config.f_161215_) {
            GingkoFancyTrunkPlacer.m_226169_((LevelSimulatedReader)level, setter, (RandomSource)random, (BlockPos)origin.m_7495_(), (TreeConfiguration)config);
        }
        int l = Math.min(3, Mth.m_14107_((double)(1.382 + Math.pow((double)j / 6.0, 3.0))));
        int i1 = origin.m_123342_() + k;
        ArrayList list = Lists.newArrayList();
        list.add(new Foliage(origin.m_6630_(j1), i1));
        for (j1 = j - 5; j1 >= 0; --j1) {
            float f = this.treeShape(j, j1);
            if (f < 0.0f) continue;
            for (int k1 = 0; k1 < l; ++k1) {
                BlockPos blockpos1;
                double d2 = 1.0 * (double)f * ((double)random.m_188501_() + 0.328);
                double d3 = (double)(random.m_188501_() * 2.0f) * Math.PI;
                double d4 = d2 * Math.sin(d3) + 0.5;
                double d5 = d2 * Math.cos(d3) + 0.5;
                BlockPos blockpos = origin.m_7918_(Mth.m_14107_((double)d4), j1 - 1, Mth.m_14107_((double)d5));
                if (!this.makeLimb(level, setter, random, blockpos, blockpos1 = blockpos.m_6630_(5), false, config)) continue;
                int l1 = origin.m_123341_() - blockpos.m_123341_();
                int i2 = origin.m_123343_() - blockpos.m_123343_();
                double d6 = (double)blockpos.m_123342_() - Math.sqrt(l1 * l1 + i2 * i2) * 0.381;
                int j2 = d6 > (double)i1 ? i1 : (int)d6;
                BlockPos blockpos2 = new BlockPos(origin.m_123341_(), j2, origin.m_123343_());
                if (!this.makeLimb(level, setter, random, blockpos2, blockpos, false, config)) continue;
                list.add(new Foliage(blockpos, blockpos2.m_123342_()));
            }
        }
        this.makeLimb(level, setter, random, origin, origin.m_6630_(k), true, config);
        this.makeBranches(level, setter, random, j, origin, list, config);
        ArrayList list1 = Lists.newArrayList();
        for (Foliage fancytrunkplacer$foliage : list) {
            list1.add(fancytrunkplacer$foliage.attachment);
        }
        return list1;
    }

    private boolean makeLimb(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> setter, RandomSource random, BlockPos pos1, BlockPos pos2, boolean force, TreeConfiguration config) {
        if (!force && Objects.equals(pos1, pos2)) {
            return true;
        }
        BlockPos blockpos = pos2.m_7918_(-pos1.m_123341_(), -pos1.m_123342_(), -pos1.m_123343_());
        int i = this.getSteps(blockpos);
        float f = (float)blockpos.m_123341_() / (float)i;
        float f1 = (float)blockpos.m_123342_() / (float)i;
        float f2 = (float)blockpos.m_123343_() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = pos1.m_7918_(Mth.m_14143_((float)(0.5f + (float)j * f)), Mth.m_14143_((float)(0.5f + (float)j * f1)), Mth.m_14143_((float)(0.5f + (float)j * f2)));
            if (force) {
                this.m_226175_(level, setter, random, blockpos1, config, state -> (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)this.getLogAxis(pos1, blockpos1)));
                continue;
            }
            if (this.m_226184_(level, blockpos1)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos p_236888_1_) {
        int i = Mth.m_14040_((int)p_236888_1_.m_123341_());
        int j = Mth.m_14040_((int)p_236888_1_.m_123342_());
        int k = Mth.m_14040_((int)p_236888_1_.m_123343_());
        return Math.max(i, Math.max(j, k));
    }

    private Direction.Axis getLogAxis(BlockPos p_236889_1_, BlockPos p_236889_2_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_236889_2_.m_123341_() - p_236889_1_.m_123341_());
        int k = Math.max(i, j = Math.abs(p_236889_2_.m_123343_() - p_236889_1_.m_123343_()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }

    private void makeBranches(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> setter, RandomSource random, int height, BlockPos pos, List<Foliage> foliage, TreeConfiguration config) {
        for (Foliage fancytrunkplacer$foliage : foliage) {
            int i = fancytrunkplacer$foliage.getBranchBase();
            BlockPos blockpos = new BlockPos(pos.m_123341_(), i, pos.m_123343_());
            if (blockpos.equals((Object)fancytrunkplacer$foliage.attachment.m_161451_())) continue;
            this.makeLimb(level, setter, random, blockpos, fancytrunkplacer$foliage.attachment.m_161451_(), true, config);
        }
    }

    private float treeShape(int p_236890_1_, int p_236890_2_) {
        if ((float)p_236890_2_ < (float)p_236890_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_236890_1_ / 2.0f;
        float f1 = f - (float)p_236890_2_;
        float f2 = Mth.m_14116_((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    static class Foliage {
        private final FoliagePlacer.FoliageAttachment attachment;
        private final int branchBase;

        public Foliage(BlockPos p_i232055_1_, int p_i232055_2_) {
            this.attachment = new FoliagePlacer.FoliageAttachment(p_i232055_1_, 0, false);
            this.branchBase = p_i232055_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

