/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.debug;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.DebugLevelSource;

public class PixelmonDebugChunkGenerator
extends DebugLevelSource {
    public static final Codec<PixelmonDebugChunkGenerator> CODEC = RecordCodecBuilder.create(p_255576_ -> p_255576_.group((App)RegistryOps.m_254866_((ResourceKey)Biomes.f_48202_)).apply((Applicative)p_255576_, p_255576_.stable(PixelmonDebugChunkGenerator::new)));
    private static List<PokemonBase> ALL_POKEMONS;
    private static int GRID_WIDTH;
    private static int GRID_HEIGHT;

    public PixelmonDebugChunkGenerator(Holder.Reference<Biome> p_i241974_1_) {
        super(p_i241974_1_);
    }

    public void m_213609_(WorldGenLevel p_230351_1_, ChunkAccess p_223984_, StructureManager p_230351_2_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ChunkPos chunkpos = p_223984_.m_7697_();
        int i = chunkpos.f_45578_;
        int j = chunkpos.f_45579_;
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = SectionPos.m_175554_((int)i, (int)k);
                int j1 = SectionPos.m_175554_((int)j, (int)l);
                p_230351_1_.m_7731_((BlockPos)blockpos$mutableblockpos.m_122178_(i1, 60, j1), f_64113_, 2);
                PokemonBase pokemonBaseFor = PixelmonDebugChunkGenerator.getPokemonBaseFor(i1, j1);
                if (pokemonBaseFor == null) continue;
                StatueEntity entity = new StatueEntity((Level)p_230351_1_.m_6018_());
                entity.setBoundingMode(EnumBoundingBoxMode.None);
                entity.m_6034_(i1, 61.0, j1);
                entity.setPokemon(pokemonBaseFor.toPokemon());
                p_230351_1_.m_7967_((Entity)entity);
            }
        }
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_223133_(Holder<Biome> p_223134_, StructureManager p_223135_, MobCategory p_223136_, BlockPos p_223137_) {
        return super.m_223133_(p_223134_, p_223135_, p_223136_, p_223137_);
    }

    public static PokemonBase getPokemonBaseFor(int posX, int posZ) {
        int i;
        if (posX > 0 && posZ > 0 && posX % 3 == 0 && posZ % 3 == 0 && posX / 20 <= GRID_WIDTH && posZ / 20 <= GRID_HEIGHT && (i = Mth.m_14040_((int)(posX / 10 * GRID_WIDTH + posZ / 10))) < ALL_POKEMONS.size()) {
            return ALL_POKEMONS.get(i);
        }
        return null;
    }

    public static void init() {
        ALL_POKEMONS = Lists.newArrayList();
        for (Species species : PixelmonSpecies.getAll()) {
            for (Stats form : species.getForms()) {
                for (GenderProperties genderProperty : form.getGenderProperties()) {
                    for (PaletteProperties palette : genderProperty.getPalettes()) {
                        ALL_POKEMONS.add(new PokemonBase(species, form, palette, genderProperty.getGender()));
                    }
                }
            }
        }
        GRID_WIDTH = Mth.m_14167_((float)Mth.m_14116_((float)ALL_POKEMONS.size()));
        GRID_HEIGHT = Mth.m_14167_((float)(ALL_POKEMONS.size() / GRID_WIDTH));
    }
}

