/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.schedulers;

import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import java.util.concurrent.Executor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PixelmonStorageStandardScheduler
implements StorageSaveScheduler {
    protected int lastSaveTick = 0;

    @Override
    public Executor getScheduler() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event) {
        this.saveAll();
        this.lastSaveTick = 0;
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        int currentTick = ServerLifecycleHooks.getCurrentServer().m_129921_();
        if (currentTick > this.lastSaveTick) {
            this.saveAll();
            this.lastSaveTick = currentTick;
        }
    }

    public void saveAll() {
        for (PokemonStorage storage : StorageProxy.getAllCachedStorages()) {
            if (!storage.getShouldSave()) continue;
            this.save(storage);
        }
    }
}

