/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.schedulers;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.StorageSaveScheduler;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.event.server.ServerStoppingEvent;

public class PixelmonStorageAsyncScheduler
implements StorageSaveScheduler {
    protected final ScheduledExecutorService executor = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_async_storage_%d").build());
    protected final Deque<PokemonStorage> saveList = new ConcurrentLinkedDeque<PokemonStorage>();
    protected final AtomicBoolean saving = new AtomicBoolean(false);

    public PixelmonStorageAsyncScheduler() {
        Pixelmon.LOGGER.info("Started the async storage scheduler.");
        this.executor.scheduleAtFixedRate(() -> {
            try {
                if (this.saving.compareAndSet(false, true)) {
                    this.queueChangedStorages();
                    this.flush();
                } else {
                    Pixelmon.LOGGER.error("Async saving reached scheduled save but something has our save lock.");
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Async saving encountered a major error.", (Throwable)e);
            }
            finally {
                this.saving.set(false);
            }
        }, PixelmonConfigProxy.getStorage().getAsyncInterval(), PixelmonConfigProxy.getStorage().getAsyncInterval(), TimeUnit.SECONDS);
    }

    @Override
    public Executor getScheduler() {
        return this.executor;
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event) {
        if (this.saving.compareAndSet(false, true)) {
            this.queueChangedStorages();
            this.flush();
            this.saving.set(false);
        } else {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                Pixelmon.LOGGER.error("Async saving encountered a major error.", (Throwable)e);
            }
            this.queueChangedStorages();
            this.flush();
            this.saving.set(false);
        }
    }

    public void queueChangedStorages() {
        for (PokemonStorage storage : StorageProxy.getAllCachedStorages()) {
            if (this.saveList.contains(storage) || !storage.getShouldSave()) continue;
            this.saveList.add(storage);
        }
    }

    public void flush() {
        while (!this.saveList.isEmpty()) {
            PokemonStorage storage = this.saveList.removeFirst();
            this.save(storage);
        }
    }
}

