/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class TeleportPosition
implements ISaveData {
    private ResourceKey<Level> dimension;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public BlockPos getPosition() {
        return new BlockPos((int)this.x, (int)this.y, (int)this.z);
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public void writeToNBT(CompoundTag nbt) {
        if (this.dimension != null && this.dimension != Level.f_46428_) {
            nbt.m_128359_("tpDimension", this.dimension.toString());
        }
        nbt.m_128347_("tpPosX", this.x);
        nbt.m_128347_("tpPosY", this.y);
        nbt.m_128347_("tpPosZ", this.z);
        nbt.m_128350_("tpRotY", this.yaw);
        nbt.m_128350_("tpRotP", this.pitch);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.dimension = nbt.m_128441_("tpDimension") ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocationHelper.of(nbt.m_128461_("tpDimension"))) : ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocationHelper.of("overworld"));
        this.x = nbt.m_128459_("tpPosX");
        this.y = nbt.m_128459_("tpPosY");
        this.z = nbt.m_128459_("tpPosZ");
        this.yaw = nbt.m_128457_("tpRotY");
        this.pitch = nbt.m_128457_("tpRotP");
    }

    public void store(ResourceKey<Level> dimension, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this.dimension = dimension;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.yaw = rotationYaw;
        this.pitch = rotationPitch;
    }

    public void teleport(ServerPlayer player) {
        ServerLevel world = player.m_20194_().m_129880_(this.dimension);
        if (world == null) {
            return;
        }
        player.m_8999_(world, this.x, this.y, this.z, this.yaw, this.pitch);
    }
}

