/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.quests.AbandonQuestEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.comm.HideDisplayQuestPacket;
import com.pixelmonmod.pixelmon.quests.comm.SetDisplayQuestPacket;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Event;

public class QuestData
implements ISaveData {
    private final ArrayList<QuestProgress> progress;
    private transient ServerPlayer player;
    private final transient ArrayList<String> activeQuests = new ArrayList();
    private final transient ArrayList<String> completeQuests = new ArrayList();

    public QuestData() {
        this.progress = new ArrayList();
    }

    public QuestData get(ServerPlayer player, boolean update) {
        this.player = player;
        if (update) {
            this.activeQuests.clear();
            this.completeQuests.clear();
            Iterator<QuestProgress> iterator = this.progress.iterator();
            while (iterator.hasNext()) {
                QuestProgress progress = iterator.next();
                if (QuestRegistry.getInstance().getQuest(progress.getQuestFilename()) == null) {
                    iterator.remove();
                    continue;
                }
                if (!progress.isComplete()) {
                    this.activeQuests.add(progress.getQuestFilename());
                    continue;
                }
                this.completeQuests.add(progress.getQuestFilename());
            }
            for (Quest quest : QuestRegistry.getInstance().getQuestCollection()) {
                if (this.activeQuests.contains(quest.getFilename()) || this.completeQuests.contains(quest.getFilename()) && !quest.isRepeatable()) continue;
                QuestProgress newQuest = new QuestProgress(quest, this);
                this.progress.add(newQuest);
                newQuest.sendTo(player);
            }
        }
        return this;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public ArrayList<QuestProgress> getProgress() {
        return this.progress;
    }

    public QuestProgress getProgressForQuest(String filename) {
        return this.getProgressForQuest(filename, false);
    }

    public QuestProgress getProgressForQuest(String filename, boolean underscoreSpaces) {
        for (QuestProgress progress : this.getProgress()) {
            if (!progress.getQuestFilename().equalsIgnoreCase(filename) && (!underscoreSpaces || !progress.getQuestFilename().equalsIgnoreCase(filename.replace("_", " ") + ".json"))) continue;
            return progress;
        }
        return null;
    }

    public void receiveInternal(String identifier, boolean breakOnSuccess, Object ... args) {
        try {
            block2: for (QuestProgress progress : this.progress) {
                if (progress.isComplete()) continue;
                Stage stage = progress.getCurrentStage();
                int i = 0;
                if (stage.getParsedObjectives() != null) {
                    for (Objective objective : stage.getParsedObjectives()) {
                        if (!objective.receive(identifier, stage, this, progress, i++, args) || !breakOnSuccess) continue;
                        break block2;
                    }
                    continue;
                }
                progress.complete(this.player);
            }
            this.get(this.player, true);
        }
        catch (InvalidQuestArgsException exception) {
            exception.printStackTrace();
        }
    }

    public void receive(String identifier, Object ... args) throws InvalidQuestArgsException {
        this.receiveInternal(identifier, false, args);
    }

    public void receiveMultipleInternal(String[] identifiers, Object[][] args, boolean breakOnSuccess) {
        try {
            block2: for (QuestProgress progress : this.progress) {
                if (progress.isComplete()) continue;
                Stage stage = progress.getCurrentStage();
                int i = 0;
                if (stage.getParsedObjectives() != null) {
                    for (Objective objective : stage.getParsedObjectives()) {
                        for (int o = 0; o < identifiers.length; ++o) {
                            if (objective.receive(identifiers[o], stage, this, progress, i, args[o]) && breakOnSuccess) break block2;
                        }
                        ++i;
                    }
                    continue;
                }
                progress.complete(this.player);
            }
            this.get(this.player, true);
        }
        catch (InvalidQuestArgsException exception) {
            exception.printStackTrace();
        }
    }

    public void receiveMultiple(String[] identifiers, Object[][] args) throws InvalidQuestArgsException {
        this.receiveMultipleInternal(identifiers, args, false);
    }

    public void abandonQuest(String filename, UUID identifier) {
        for (QuestProgress progress : this.progress) {
            if (!progress.getQuestFilename().equals(filename) || !progress.getIdentifier().equals(identifier) || !progress.isAbandonable() || progress.isComplete() || progress.getStage() < progress.getQuest().getActiveStage() || Pixelmon.EVENT_BUS.post((Event)new AbandonQuestEvent(this.player, progress))) continue;
            progress.fail(this.player);
        }
    }

    public void setTracking(QuestProgress progress) {
        if (this.player != null) {
            NetworkHelper.sendPacket(new SetDisplayQuestPacket(progress), this.player);
        }
    }

    public void hideTracking() {
        if (this.player != null) {
            NetworkHelper.sendPacket(new HideDisplayQuestPacket(), this.player);
        }
    }

    @Override
    public void writeToNBT(CompoundTag nbt) {
        ListTag tagList = new ListTag();
        for (QuestProgress progress : this.progress) {
            CompoundTag tag = new CompoundTag();
            progress.writeToNBT(tag);
            tagList.add((Object)tag);
        }
        nbt.m_128365_("Quests", (Tag)tagList);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.progress.clear();
        if (nbt.m_128441_("Quests")) {
            ListTag list = nbt.m_128437_("Quests", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = (CompoundTag)list.get(i);
                String filename = tag.m_128461_("QuestFilename");
                if (QuestRegistry.getInstance().getQuest(filename) == null) {
                    Pixelmon.LOGGER.warn("Found invalid quest data " + filename + ", throwing out (A)");
                    continue;
                }
                try {
                    this.progress.add(new QuestProgress(tag, this));
                    continue;
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.warn("Found invalid quest data " + filename + ", throwing out (B)");
                    e.printStackTrace();
                }
            }
        }
    }
}

