/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.battles.CatchComboEvent;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Event;

public class CaptureCombo {
    private Species lastCapture;
    private int captureCount;
    private int currentThresholdIndex;

    public void onCapture(ServerPlayer player, Species species) {
        if (PixelmonConfigProxy.getBattle().isAllowCatchCombo()) {
            this.captureCount = this.lastCapture == species ? ++this.captureCount : 1;
            this.lastCapture = species;
            this.refreshThresholdIndex();
            Pixelmon.EVENT_BUS.post((Event)new CatchComboEvent.ComboIncrement(player, this.lastCapture, this.captureCount));
        } else {
            this.clearCombo();
        }
    }

    public int getCurrentCombo() {
        return this.captureCount;
    }

    public Species getCurrentSpecies() {
        return this.lastCapture;
    }

    public void clearCombo() {
        this.lastCapture = null;
        this.captureCount = 0;
        this.currentThresholdIndex = 0;
    }

    public int getCurrentThreshold() {
        return this.currentThresholdIndex;
    }

    public int refreshThresholdIndex() {
        for (int i = 0; i < PixelmonConfigProxy.getBattle().getCatchComboThresholds().size(); ++i) {
            if (this.captureCount > PixelmonConfigProxy.getBattle().getCatchComboThresholds().get(i)) continue;
            this.currentThresholdIndex = i;
            return this.currentThresholdIndex;
        }
        this.currentThresholdIndex = PixelmonConfigProxy.getBattle().getCatchComboThresholds().size();
        return this.currentThresholdIndex;
    }

    public float getBaseExpBonus() {
        return PixelmonConfigProxy.getBattle().getCatchComboExpBonuses().size() > 0 ? PixelmonConfigProxy.getBattle().getCatchComboExpBonuses().get(0).floatValue() : 1.0f;
    }

    public float getExpBouns() {
        return PixelmonConfigProxy.getBattle().getCatchComboExpBonuses().size() > this.currentThresholdIndex ? PixelmonConfigProxy.getBattle().getCatchComboExpBonuses().get(this.currentThresholdIndex).floatValue() : 1.0f;
    }

    public float getBaseShinyModifier() {
        return PixelmonConfigProxy.getBattle().getCatchComboShinyModifiers().size() > 0 ? PixelmonConfigProxy.getBattle().getCatchComboShinyModifiers().get(0).floatValue() : 1.0f;
    }

    public float getShinyModifier() {
        return PixelmonConfigProxy.getBattle().getCatchComboShinyModifiers().size() > this.currentThresholdIndex ? PixelmonConfigProxy.getBattle().getCatchComboShinyModifiers().get(this.currentThresholdIndex).floatValue() : 1.0f;
    }

    public int getBasePerfIVCount() {
        return PixelmonConfigProxy.getBattle().getCatchComboPerfectIVs().size() > 0 ? PixelmonConfigProxy.getBattle().getCatchComboPerfectIVs().get(0) : 0;
    }

    public int getPerfIVCount() {
        return PixelmonConfigProxy.getBattle().getCatchComboPerfectIVs().size() > this.currentThresholdIndex ? PixelmonConfigProxy.getBattle().getCatchComboPerfectIVs().get(this.currentThresholdIndex) : 0;
    }
}

