/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayServerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RequestExtrasDisplayDataPacket;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class PlayerExtraDataStore {
    private static PixelExtrasData client;
    private static final Map<UUID, PixelExtrasData> playerExtras;

    public static void add(PixelExtrasData data) {
        if (Objects.equals(PlayerExtraDataStore.client.id, data.id)) {
            client.updateServerCosmetics(data.getServerCosmetics());
            return;
        }
        playerExtras.put(data.id, data);
    }

    public static PixelExtrasData get(Player player) {
        return PlayerExtraDataStore.get(player.m_20148_());
    }

    public static PixelExtrasData get(UUID uuid) {
        if (Objects.equals(PlayerExtraDataStore.client.id, uuid)) {
            return client;
        }
        if (!playerExtras.containsKey(uuid)) {
            playerExtras.put(uuid, new PixelExtrasData(uuid));
            NetworkHelper.sendToServer(new RequestExtrasDisplayDataPacket(uuid));
        }
        return playerExtras.get(uuid);
    }

    public static boolean canSeeTexture(Player owner, Species species) {
        return owner != null && PlayerExtraDataStore.get(owner).canSeeTexture(species);
    }

    public static void refreshClient(Consumer<PixelExtrasData> consumer) {
        ExtrasContact.updateSelf(client, true, consumer.andThen(data -> PlayerExtraDataStore.saveAndRefresh()));
    }

    public static void saveAndSend() {
        PlayerExtraDataStore.sendDisplayPacket();
        PlayerExtraDataStore.saveClientData();
    }

    public static void saveAndRefresh() {
        PlayerExtraDataStore.saveClientData();
        if (client.isReady() && client.hasData()) {
            PixelExtrasDisplayServerPacket packet = new PixelExtrasDisplayServerPacket(client);
            packet.dataHash = -1;
            NetworkHelper.sendToServer(packet);
        }
    }

    public static void sendDisplayPacket() {
        if (client.isReady() && client.hasData()) {
            NetworkHelper.sendToServer(new PixelExtrasDisplayServerPacket(client));
        }
    }

    public static void loadClientData() {
        File file;
        UUID uuid = Minecraft.m_91087_().m_91094_().m_240411_();
        client = new PixelExtrasData(uuid);
        if (!Pixelmon.isDevEnvironment() && (file = new File(Minecraft.m_91087_().f_91069_, "pixel.dat")).exists()) {
            CompoundTag compound = new CompoundTag();
            try (FileInputStream in = new FileInputStream(file);){
                compound = NbtIo.m_128939_((InputStream)in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (compound.m_128441_(uuid.toString())) {
                CompoundTag nbt = compound.m_128469_(uuid.toString());
                ExtrasContact.updateSelf(client, false, newData -> {
                    client = newData;
                    newData.setHatType(PixelExtrasData.HatType.getFromId(nbt.m_128445_("hatType")));
                    newData.setMonocleType(PixelExtrasData.MonocleType.getFromId(nbt.m_128445_("monocleType")));
                    if (nbt.m_128441_("sashType")) {
                        newData.setSashType(PixelExtrasData.SashType.values()[nbt.m_128445_("sashType")]);
                    }
                    if (nbt.m_128441_("robeType")) {
                        newData.setRobeType(PixelExtrasData.RobeType.values()[nbt.m_128445_("robeType")]);
                    }
                    if (nbt.m_128441_("sphealType")) {
                        newData.setSphealType(PixelExtrasData.SphealType.values()[nbt.m_128445_("sphealType")]);
                    }
                    for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
                        if (nbt.m_128441_("en" + category.name().toLowerCase(Locale.ROOT))) {
                            newData.setEnabled(category, nbt.m_128471_("en" + category.name().toLowerCase(Locale.ROOT)));
                        } else {
                            newData.setEnabled(category, true);
                        }
                        if (!nbt.m_128441_("c" + category.name().toLowerCase(Locale.ROOT))) continue;
                        newData.setColours(category, nbt.m_128465_("c" + category.name().toLowerCase(Locale.ROOT)));
                    }
                    PlayerExtraDataStore.saveClientData();
                });
                return;
            }
        }
        ExtrasContact.updateSelf(client, false, newData -> {
            client = newData;
            PlayerExtraDataStore.saveClientData();
        });
    }

    public static void saveClientData() {
        File file = new File(Minecraft.m_91087_().f_91069_, "pixel.dat");
        CompoundTag compound = new CompoundTag();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try (FileInputStream in = new FileInputStream(file);){
            compound = NbtIo.m_128939_((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("hatType", (byte)PlayerExtraDataStore.client.getHatType().id);
        nbt.m_128344_("monocleType", (byte)PlayerExtraDataStore.client.getMonocleType().id);
        if (PlayerExtraDataStore.client.sashType != null) {
            nbt.m_128344_("sashType", (byte)client.getSashType().ordinal());
        }
        if (PlayerExtraDataStore.client.robeType != null) {
            nbt.m_128344_("robeType", (byte)client.getRobeType().ordinal());
        }
        if (PlayerExtraDataStore.client.sphealType != null) {
            nbt.m_128344_("sphealType", (byte)client.getSphealType().ordinal());
        }
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            nbt.m_128379_("en" + category.name().toLowerCase(Locale.ROOT), client.isEnabled(category));
            if (client.getColours(category) == null) continue;
            nbt.m_128385_("c" + category.name().toLowerCase(Locale.ROOT), client.getColours(category));
        }
        compound.m_128365_(PlayerExtraDataStore.client.id.toString(), (Tag)nbt);
        try (FileOutputStream out = new FileOutputStream(file);){
            NbtIo.m_128947_((CompoundTag)compound, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        playerExtras = new HashMap<UUID, PixelExtrasData>();
    }
}

