/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.InteractionDeveloper;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

public class ExtrasContact {
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_extras_contact_%d").build());
    private static final Map<UUID, Tuple<Tuple<EnumSet<Groups>, int[]>, Instant>> cache = Maps.newHashMap();
    private static final String DIRECT = "https://api.pixelmonmod.com/arctic/" + ExtrasContact.getVersion() + "/mc_group.php?uuid=";
    private static final String CACHE = "https://ogn.pixelmonmod.com/arctic/" + ExtrasContact.getVersion() + "/mc_group.php?uuid=";

    private static Tuple<EnumSet<Groups>, int[]> queryApi(UUID uuid, boolean force) throws IOException {
        if (Pixelmon.isDevEnvironment() || uuid.equals(InteractionDeveloper.isi)) {
            return new Tuple(EnumSet.allOf(Groups.class), (Object)new int[]{0, 0, 0});
        }
        String uuidStr = RegexPatterns.DASH_SYMBOL.matcher(uuid.toString()).replaceAll("");
        URL url = new URL((force ? DIRECT : CACHE) + uuidStr);
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        String response = IOUtils.toString((InputStream)connection.getInputStream());
        return ExtrasContact.parseData(response);
    }

    private static Tuple<EnumSet<Groups>, int[]> parseData(String responce) {
        String[] splits = responce.split(";");
        String[] groups = splits[0].split(",");
        EnumSet<Groups> list = EnumSet.noneOf(Groups.class);
        for (String group : groups) {
            String g = RegexPatterns.NEWLINE_CHAR.matcher(group).replaceAll("").trim();
            int grp = Integer.parseInt(g);
            if (Groups.getFromId(grp) == null) continue;
            list.add(Groups.getFromId(grp));
        }
        int[] colours = new int[3];
        if (splits.length > 1) {
            String[] str = splits[1].split(",");
            colours[0] = Integer.parseInt(str[0]);
            colours[1] = Integer.parseInt(str[1]);
            colours[2] = Integer.parseInt(str[2]);
        }
        return new Tuple(list, (Object)colours);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateSelf(PixelExtrasData data, boolean update, Consumer<PixelExtrasData> consumer) {
        UUID uuid = Minecraft.m_91087_().m_91094_().m_240411_();
        if (!update && ExtrasContact.fromCache(data)) {
            consumer.accept(data);
        } else {
            executorService.submit(() -> {
                try {
                    data.apiData = ExtrasContact.queryApi(uuid, update);
                    StringJoiner joiner = new StringJoiner(", ", "[", "]");
                    ((EnumSet)data.apiData.m_14418_()).forEach(g -> joiner.add("" + g.id));
                    Pixelmon.LOGGER.info("Query response: groups" + joiner + " colors" + Arrays.toString((int[])data.apiData.m_14419_()));
                    cache.put(data.id, (Tuple<Tuple<EnumSet<Groups>, int[]>, Instant>)new Tuple(data.apiData, (Object)Instant.now()));
                }
                catch (IOException e) {
                    Pixelmon.LOGGER.info("Couldn't connect to Pixelmon servers: " + e.getLocalizedMessage());
                }
                consumer.accept(data);
            });
        }
    }

    public static CompletableFuture<PixelExtrasData> updateData(PixelExtrasData data, int hash) {
        if (ExtrasContact.fromCache(data) && ExtrasContact.checkCacheHash(data.id, hash)) {
            return CompletableFuture.completedFuture(data);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                data.apiData = ExtrasContact.queryApi(data.id, false);
                cache.put(data.id, (Tuple<Tuple<EnumSet<Groups>, int[]>, Instant>)new Tuple(data.apiData, (Object)Instant.now()));
            }
            catch (IOException e) {
                Pixelmon.LOGGER.info("Couldn't connect to Pixelmon servers: {}", (Object)e.getLocalizedMessage());
            }
            return data;
        }, executorService);
    }

    public static boolean checkCacheHash(UUID uuid, int hash) {
        int h = 0;
        if (!cache.containsKey(uuid)) {
            return false;
        }
        for (Groups group : (EnumSet)((Tuple)cache.get(uuid).m_14418_()).m_14418_()) {
            if (group == null) continue;
            h = 31 * h + (group.ordinal() + 1);
        }
        return h == hash;
    }

    static boolean fromCache(PixelExtrasData data) {
        if (data.id.version() != 4) {
            int[] colours = new int[3];
            Arrays.fill(colours, -1);
            data.apiData = new Tuple(EnumSet.noneOf(Groups.class), (Object)colours);
            return true;
        }
        if (cache.containsKey(data.id) && ((Instant)cache.get(data.id).m_14419_()).getEpochSecond() > Instant.now().getEpochSecond() - 604800L) {
            data.apiData = (Tuple)cache.get(data.id).m_14418_();
            return true;
        }
        return false;
    }

    private static void saveCache() {
        Properties properties = new Properties();
        Iterator<Map.Entry<UUID, Tuple<Tuple<EnumSet<Groups>, int[]>, Instant>>> iterator = cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Tuple<Tuple<EnumSet<Groups>, int[]>, Instant>> entry = iterator.next();
            if (((Instant)entry.getValue().m_14419_()).getEpochSecond() < Instant.now().getEpochSecond() - 604800L) {
                iterator.remove();
                continue;
            }
            Instant instant = (Instant)entry.getValue().m_14419_();
            EnumSet groups = (EnumSet)((Tuple)entry.getValue().m_14418_()).m_14418_();
            int[] colours = (int[])((Tuple)entry.getValue().m_14418_()).m_14419_();
            ByteBuffer buf = ByteBuffer.allocate(8 + (groups.size() + 1) * 1 + 12);
            buf.putLong(instant.getEpochSecond());
            buf.put((byte)groups.size());
            for (Groups group : groups) {
                buf.put((byte)group.id);
            }
            buf.putInt(colours[0]).putInt(colours[1]).putInt(colours[2]);
            properties.setProperty(entry.getKey().toString(), Base64.getEncoder().encodeToString(buf.array()));
        }
        if (properties.isEmpty()) {
            return;
        }
        File file = new File("pixelc.dat");
        try (FileOutputStream out = new FileOutputStream(file);){
            properties.store(out, "pixelmon cache");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadCache() {
        File file = new File("pixelc.dat");
        if (!file.exists()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        catch (IOException e) {
            return;
        }
        file.delete();
        for (Object key : properties.keySet()) {
            UUID uuid = UUID.fromString((String)key);
            ByteBuffer buf = ByteBuffer.wrap(Base64.getDecoder().decode(properties.getProperty(uuid.toString())));
            Instant instant = Instant.ofEpochSecond(buf.getLong());
            int count = buf.get();
            EnumSet<Groups> groups = EnumSet.noneOf(Groups.class);
            for (int i = 0; i < count; ++i) {
                Groups group = Groups.getFromId(buf.get());
                if (group == null) continue;
                groups.add(group);
            }
            int[] colours = new int[]{buf.getInt(), buf.getInt(), buf.getInt()};
            cache.put(uuid, (Tuple<Tuple<EnumSet<Groups>, int[]>, Instant>)new Tuple((Object)new Tuple(groups, (Object)colours), (Object)instant));
        }
    }

    public static String getVersion() {
        return RegexPatterns.DOT_SYMBOL.matcher("9.2.6").replaceAll("");
    }

    static {
        ExtrasContact.loadCache();
        Runtime.getRuntime().addShutdownHook(new Thread(ExtrasContact::saveCache));
    }

    static enum Groups {
        Admin(5),
        Junior_Admin(21),
        Modeler(39),
        Developer(43),
        Support(44),
        CompWinner(53),
        Trainer_Cap(45),
        Sash(47),
        Spectral_Jeweller(48),
        Rainbow_Sash(56),
        Shadow_Lugia(62),
        AlterRobe(63),
        Pikahood(64),
        Monocle_Gold(65),
        Monocle_Black(66),
        Wiki(67),
        Wobbuffet(68),
        NitroBooster(69),
        EeveeHood(71),
        SphealHats(72),
        JASFPorygon_Z(73),
        PDSentret(74),
        ELGreninja(75),
        SFXMewtwo(76),
        HaaMask(77),
        QuarantineMask(79),
        Welkin(80),
        Froslass_Yukata(81),
        IRWLucario(82),
        StrikeRobe(83),
        AshenRobe(84),
        CinderaceGoku(85),
        BugcatcherMothim(86),
        ChristmasSpheal(87),
        AnniversaryHood(88),
        ChristmasWings(89),
        ValentinesWings(91),
        WitchHat(92);

        int id;

        private Groups(int id) {
            this.id = id;
        }

        public boolean is(Groups ... groups) {
            for (Groups group : groups) {
                if (this != group) continue;
                return true;
            }
            return false;
        }

        public static Groups getFromId(int id) {
            for (Groups group : Groups.values()) {
                if (id != group.id) continue;
                return group;
            }
            return null;
        }
    }
}

