/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnActionNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;

public class UltraSpaceLevelTweak
implements SpawningTweak {
    @Override
    public void doTweak(AbstractSpawner spawner, SpawnAction<? extends Entity> action) {
        if (action instanceof SpawnActionPokemon) {
            SpawnActionPokemon actionPokemon = (SpawnActionPokemon)action;
            if (!(action.spawnInfo instanceof SpawnInfoPokemon)) {
                return;
            }
            SpawnInfoPokemon spawnInfo = (SpawnInfoPokemon)action.spawnInfo;
            PixelmonEntity pixelmon = (PixelmonEntity)((Object)actionPokemon.getOrCreateEntity());
            if (pixelmon.isBossPokemon()) {
                return;
            }
            int newLevel = this.getTweakedLevel(actionPokemon, actionPokemon.pokemon.getPokemonLevel(), spawnInfo.minLevel, spawnInfo.maxLevel);
            pixelmon.getPokemon().setLevel(newLevel);
            pixelmon.m_21153_(pixelmon.getPokemon().getHealth());
        } else if (action instanceof SpawnActionNPCTrainer) {
            SpawnActionNPCTrainer actionTrainer = (SpawnActionNPCTrainer)action;
            SpawnInfoNPCTrainer infoTrainer = (SpawnInfoNPCTrainer)actionTrainer.spawnInfo;
            NPCTrainer trainer = (NPCTrainer)((Object)actionTrainer.getOrCreateEntity());
            trainer.setPokemonLevel(this.getTweakedLevel(actionTrainer, trainer.pokemonLevel, infoTrainer.getMinLevel(), infoTrainer.getMaxLevel()));
        }
    }

    public int getTweakedLevel(SpawnAction<? extends Entity> action, int level, int min, int max) {
        if (min == max || !(action.spawnLocation.cause instanceof ServerPlayer) || action.spawnLocation.location == null || action.spawnLocation.location.pos == null) {
            return level;
        }
        ServerPlayer cause = (ServerPlayer)action.spawnLocation.cause;
        if (!UltraSpace.is((LevelReader)cause.m_9236_())) {
            return level;
        }
        return (int)(PixelmonConfigProxy.getSpawning().getUltraSpaceLevelMultiplier() * (double)level);
    }
}

