/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.quest;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.ForgeI18n;

public class Quest {
    public static Class<? extends Quest> standardQuest = Quest.class;
    private int weight;
    private boolean abandonable;
    private boolean repeatable;
    private QuestColor color;
    private short activeStage;
    private ArrayList<Stage> stages;
    private HashMap<String, String> strings;
    private transient HashMap<Short, Stage> mappedStages = new HashMap();
    private transient String filename;
    private static final String[] newQuestNames = new String[]{"The Phantom Quest", "Attack of the Quests", "Revenge of the Quest", "A New Quest", "The Quest Strikes Back", "Return of the Quest", "The Quest Awakens", "The Last Quest", "The Rise of Quest"};

    public Quest() {
        this.stages = new ArrayList();
        this.weight = 0;
        this.abandonable = true;
        this.color = new QuestColor(255, 255, 0);
        this.activeStage = (short)10;
        this.strings = new HashMap();
    }

    public Quest(String filename) {
        this();
        this.filename = filename;
        this.stages.add(new Stage(0, 10, "BLOCKER"));
        this.stages.add(new Stage(10, -1, "BLOCKER"));
        this.setDefaultStrings();
        this.setDefaultStrings(0, 1);
        this.setDefaultStrings(10, 1);
    }

    public Quest(Quest toCopy, String newFilename) {
        this.weight = toCopy.weight;
        this.abandonable = toCopy.abandonable;
        this.repeatable = toCopy.repeatable;
        this.color = new QuestColor(toCopy.color.getRGB());
        this.activeStage = toCopy.activeStage;
        this.stages = new ArrayList();
        for (Stage stage : toCopy.stages) {
            this.stages.add(new Stage(stage));
        }
        this.strings = new HashMap<String, String>(toCopy.strings);
        this.filename = newFilename;
    }

    public Quest(FriendlyByteBuf buf) {
        this.readFromByteBuf(buf);
    }

    public void putNewStringIfNeeded(String key, String value) {
        String langKey = this.getLangKey(key);
        String message = ForgeI18n.parseMessage((String)langKey, (Object[])new Object[0]);
        if (message == null || message.isEmpty() || message.equalsIgnoreCase(langKey)) {
            this.strings.putIfAbsent(key, value);
        }
    }

    public void setDefaultStrings() {
        this.putNewStringIfNeeded("name", newQuestNames[RandomHelper.getRandom().nextInt(9)]);
        this.putNewStringIfNeeded("desc-X", "Quest Complete");
    }

    public void setDefaultStrings(int stage, int objectives) {
        this.putNewStringIfNeeded("desc-" + stage, "Stage " + stage + " Description");
        for (int i = 0; i < objectives; ++i) {
            this.setDefaultStrings(stage, i, true);
        }
    }

    public void setDefaultStrings(int stage, int objective, boolean unused) {
        this.putNewStringIfNeeded("stage-" + stage + "-" + objective, "Complete an Objective");
    }

    public void clearDefaultStrings(int stage, int objectives) {
        this.strings.remove("desc-" + stage);
        for (int i = 0; i < objectives; ++i) {
            this.clearDefaultStrings(stage, i, true);
        }
    }

    public void clearDefaultStrings(int stage, int objective, boolean unused) {
        this.strings.remove("stage-" + stage + "-" + objective);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void parseAndMap() throws InvalidQuestArgsException {
        for (Stage stage : this.stages) {
            stage.parse(this);
            this.mappedStages.put(stage.getStage(), stage);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getIdentityName() {
        return this.filename.replace(" ", "_").replace(".json", "");
    }

    public String getPrintableName() {
        return this.getIdentityName().replace("_", " ");
    }

    public QuestColor getColor() {
        return this.color;
    }

    public void setColor(QuestColor color) {
        this.color = color;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void toggleRepeatability() {
        this.repeatable = !this.repeatable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public void toggleAbandonability() {
        this.abandonable = !this.abandonable;
    }

    public short getActiveStage() {
        return this.activeStage;
    }

    public void setActiveStage(short activeStage) {
        this.activeStage = activeStage;
    }

    public ArrayList<Stage> getStages() {
        return this.stages;
    }

    public Stage getStage(QuestProgress progress) {
        Stage stage = this.mappedStages.get(progress.getStage());
        if (stage == null) {
            Stage previousStage = null;
            for (Stage s : this.stages) {
                if (s.getStage() > progress.getStage()) {
                    if (previousStage == null) {
                        progress.setStage((short)0);
                    } else {
                        progress.setStage(previousStage.getStage());
                    }
                    stage = this.mappedStages.get(progress.getStage());
                    break;
                }
                previousStage = s;
            }
        }
        return stage;
    }

    public Stage getStage(short stage) {
        for (Stage s : this.stages) {
            if (s.getStage() != stage) continue;
            return s;
        }
        return null;
    }

    public Stage getNextStage(short stage) {
        short next = -1;
        for (Stage s : this.stages) {
            if (s.getStage() >= next && next != -1 || s.getStage() <= stage) continue;
            next = s.getStage();
        }
        if (next == -1) {
            return null;
        }
        return this.getStage(next);
    }

    public String getUnlocalizedString(String key) {
        return this.getUnlocalizedString(key, null);
    }

    public String getUnlocalizedString(String key, @Nullable QuestProgress progress) {
        String string = this.strings.get(key);
        if (string == null || string.isEmpty()) {
            return this.getLangKey(key);
        }
        return TextHelper.format(string);
    }

    public String getLangKey(String key) {
        return ("quest." + this.getIdentityName() + "." + key).toLowerCase(Locale.ROOT);
    }

    public HashMap<String, String> getUnlocalizedStringMap() {
        return this.strings;
    }

    public void putUnlocalizedString(String key, String value) {
        this.strings.put(key, value);
    }

    public void removeUnlocalizedString(String key) {
        this.strings.remove(key);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void readFromByteBuf(FriendlyByteBuf buf) {
        this.weight = buf.readInt();
        this.abandonable = buf.readBoolean();
        this.repeatable = buf.readBoolean();
        this.color = new QuestColor((ByteBuf)buf);
        this.activeStage = buf.readShort();
        this.stages = new ArrayList();
        int stageCount = buf.readShort();
        for (int i = 0; i < stageCount; ++i) {
            this.stages.add(new Stage(buf));
        }
        this.strings = new HashMap();
        int stringCount = buf.readShort();
        for (int i = 0; i < stringCount; ++i) {
            this.strings.put(buf.m_130277_(), buf.m_130277_());
        }
        this.filename = buf.m_130277_();
    }

    public void writeToByteBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.weight);
        buf.writeBoolean(this.abandonable);
        buf.writeBoolean(this.repeatable);
        this.color.writeToByteBuf((ByteBuf)buf);
        buf.writeShort((int)this.activeStage);
        buf.writeShort(this.stages.size());
        for (Stage stage : this.stages) {
            stage.writeToByteBuf(buf);
        }
        buf.writeShort(this.strings.size());
        for (Map.Entry entry : this.strings.entrySet()) {
            buf.m_130070_((String)entry.getKey());
            buf.m_130070_((String)entry.getValue());
        }
        if (this.filename == null) {
            this.filename = "?";
        }
        buf.m_130070_(this.filename);
    }

    public static class Builder {
        private final Quest quest = new Quest();

        public Builder setColor(QuestColor color) {
            this.quest.color = color;
            return this;
        }

        public Builder setRepeatable(boolean repeatable) {
            this.quest.repeatable = repeatable;
            return this;
        }

        public Builder setAbandonable(boolean abandonable) {
            this.quest.abandonable = abandonable;
            return this;
        }

        public Builder setWeight(int weight) {
            this.quest.weight = weight;
            return this;
        }

        public Builder setActiveStage(short activeStage) {
            this.quest.activeStage = activeStage;
            return this;
        }

        public Builder addString(String key, String value) {
            this.quest.strings.put(key, value);
            return this;
        }

        public Stage.Builder addStage() {
            return new Stage.Builder(this);
        }

        void addStage(Stage stage) {
            this.quest.stages.add(stage);
        }

        public Quest build(String identifier) throws InvalidQuestArgsException {
            this.quest.filename = identifier;
            this.quest.parseAndMap();
            this.quest.setDefaultStrings();
            return this.quest;
        }
    }
}

