/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.quest;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import java.util.function.Function;

public class Argument<T> {
    private final String key;
    private final Function<String, T> castFunction;
    private T value;
    private T defaultValue = null;
    private final boolean empty;

    private Argument(T value) {
        this.key = null;
        this.castFunction = null;
        this.value = value;
        this.empty = false;
    }

    public static <T> Argument<T> of(T value) {
        return new Argument<T>(value);
    }

    private Argument(String key, Function<String, T> castFunction) {
        if (key.startsWith("?") && key.endsWith("?")) {
            this.key = key.replace("?", "");
            this.castFunction = castFunction;
            this.value = null;
            this.empty = false;
        } else if (key.isEmpty() || key.equalsIgnoreCase("-")) {
            this.key = null;
            this.castFunction = null;
            this.value = null;
            this.empty = true;
        } else {
            String potential;
            this.value = this.cast(castFunction, key);
            if (this.value instanceof String && (potential = (String)this.value).startsWith("?") && potential.endsWith("?")) {
                this.key = potential.replace("?", "");
                this.castFunction = castFunction;
                this.value = null;
                this.empty = false;
                return;
            }
            this.key = null;
            this.castFunction = null;
            this.empty = false;
        }
    }

    public static <T> Argument<T> from(String key, Function<String, T> castFunction) {
        return new Argument<T>(key, castFunction);
    }

    private Argument(String key, Function<String, T> castFunction, T defaultValue) {
        this.defaultValue = defaultValue;
        if (key.startsWith("?") && key.endsWith("?")) {
            this.key = key.replace("?", "");
            this.castFunction = castFunction;
            this.value = null;
        } else if (key.isEmpty() || key.equalsIgnoreCase("-")) {
            this.key = null;
            this.castFunction = null;
            this.value = defaultValue;
        } else {
            String potential;
            this.value = this.cast(castFunction, key);
            if (this.value instanceof String && (potential = (String)this.value).startsWith("?") && potential.endsWith("?")) {
                this.key = potential.replace("?", "");
                this.castFunction = castFunction;
                this.value = null;
                this.empty = false;
                return;
            }
            this.key = null;
            this.castFunction = null;
        }
        this.empty = false;
    }

    public static <T> Argument<T> from(String key, Function<String, T> castFunction, T defaultValue) {
        return new Argument<T>(key, castFunction, defaultValue);
    }

    public T value(QuestProgress progress) {
        if (this.key != null && this.value == null) {
            String s = progress.getDataString(this.key);
            if (s != null) {
                return this.cast(s);
            }
            Long l = progress.getDataLong(this.key);
            if (l != null) {
                return this.cast(String.valueOf(l));
            }
        } else {
            return this.value;
        }
        return null;
    }

    public boolean isPresent(QuestProgress progress) {
        return this.isEmpty() || this.value(progress) != null;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private T cast(String in) {
        return this.cast(this.castFunction, in);
    }

    private T cast(Function<String, T> castFunction, String in) {
        try {
            return castFunction.apply(in);
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Failed to cast quest argument: " + in);
            return this.defaultValue;
        }
    }
}

