/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.player;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemObjective
implements IObjective {
    private final String identifier;
    private final boolean itemList;
    private final boolean seekMatch;

    public ItemObjective(String identifier) {
        this(identifier, false, true);
    }

    public ItemObjective(String identifier, boolean itemList, boolean seekMatch) {
        this.identifier = identifier;
        this.itemList = itemList;
        this.seekMatch = seekMatch;
    }

    @Override
    public int quantity(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments) {
        return arguments.quantity(1, progress);
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("item", false, false, ArgumentType.ITEM, new String[0]), new QuestElementArgument("count", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("damage", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("display_name", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("nbt", true, false, ArgumentType.TEXT, new String[0]));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(s)), null), Argument.from(args.get(1), Integer::parseInt, -1), Argument.from(args.get(2), Integer::parseInt, -1), Argument.from(args.get(3), TextHelper::format, ""), Argument.from(args.get(4), s -> {
            try {
                return TagParser.m_129359_((String)s);
            }
            catch (Exception e) {
                return new CompoundTag();
            }
        }, new CompoundTag()));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        if (this.itemList) {
            Item item = (Item)arguments.value(0, progress);
            Integer count = (Integer)arguments.value(1, progress);
            Integer damage = (Integer)arguments.value(2, progress);
            String name = (String)arguments.value(3, progress);
            CompoundTag nbt = (CompoundTag)arguments.value(4, progress);
            List items = (List)context.get(0);
            for (ItemStack stack : items) {
                if (stack.m_41619_() || !ItemObjective.compare(stack, item, count, damage, name, nbt)) continue;
                return this.seekMatch;
            }
            return !this.seekMatch;
        }
        return ItemObjective.compare((ItemStack)context.get(0), (Item)arguments.value(0, progress), 1, (Integer)arguments.value(2, progress), (String)arguments.value(3, progress), (CompoundTag)arguments.value(4, progress));
    }

    public static boolean compare(ItemStack stack, Item item, int count, int damage, String name, CompoundTag nbt) {
        if (item != null && stack.m_41720_() != item) {
            return false;
        }
        if (count > 0 && count < stack.m_41613_()) {
            return false;
        }
        if (damage >= 0 && damage != stack.m_41773_()) {
            return false;
        }
        if (!name.isEmpty() && !stack.m_41786_().getString().equalsIgnoreCase(name)) {
            return false;
        }
        if (!nbt.m_128456_()) {
            if (stack.m_41782_()) {
                CompoundTag stackNbt = stack.m_41783_();
                for (String key : nbt.m_128431_()) {
                    Tag base;
                    if (stackNbt.m_128425_(key, (int)(base = nbt.m_128423_(key)).m_7060_())) {
                        Tag stackBase = stackNbt.m_128423_(key);
                        if (stackBase.equals(base)) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

