/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.inserters;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;

public class InsertTypingObjective
implements IObjective {
    @Override
    public String identifier() {
        return "TYPING_INSERTER";
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> s), Argument.from(args.get(1), s -> {
            String[] strs = s.split(";");
            if (strs.length == 0) {
                return null;
            }
            Element[] types = new Element[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                types[i] = Element.parseType(strs[i]);
            }
            return types;
        }, null));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        String key = (String)arguments.value(0, progress);
        String testStr = progress.getDataString(key);
        if (testStr != null && !testStr.isEmpty()) {
            return false;
        }
        Element[] options = (Element[])arguments.value(1, progress);
        Element selected = options == null ? Element.getRandomType(false) : options[RandomHelper.getRandom().nextInt(options.length)];
        progress.setData(key, selected.name());
        progress.sendTo(data.getPlayer());
        return true;
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("key", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("typings", true, false, ArgumentType.TEXT, new String[0]));
    }
}

