/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.inserters;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import org.apache.commons.lang3.math.NumberUtils;

public class InsertOperationObjective
implements IObjective {
    @Override
    public String identifier() {
        return "OPERATION_INSERTER";
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> s), Argument.from(args.get(1), s -> s), Argument.from(args.get(2), s -> s), Argument.from(args.get(3), Operator::get, Operator.Addition), Argument.from(args.get(4), Mode::get, Mode.None));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        String key = (String)arguments.value(0, progress);
        String testStr = progress.getDataString(key);
        if (testStr != null && !testStr.isEmpty()) {
            return false;
        }
        String v1 = progress.getData((String)arguments.value(1, progress));
        String v2 = progress.getData((String)arguments.value(2, progress));
        if (NumberUtils.isParsable((String)v1) && NumberUtils.isParsable((String)v2)) {
            double d1 = Double.parseDouble(v1);
            double d2 = Double.parseDouble(v2);
            Operator operator = (Operator)((Object)arguments.value(3, progress));
            Mode mode = (Mode)((Object)arguments.value(4, progress));
            progress.setData(key, mode.perform(operator.calculate(d1, d2)));
            progress.sendTo(data.getPlayer());
            return true;
        }
        return false;
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("key", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("other_key", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("other_key", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("operator", false, false, ArgumentType.TEXT, "Addition", "Subtraction", "Multiplication", "Division", "Modulo", "Power"), new QuestElementArgument("mode", false, false, ArgumentType.TEXT, "None", "Round", "Floor", "Ceiling"));
    }

    public static enum Operator {
        Addition,
        Subtraction,
        Multiplication,
        Division,
        Modulo,
        Power;


        public double calculate(double a, double b) {
            switch (this) {
                case Subtraction: {
                    return a - b;
                }
                case Multiplication: {
                    return a * b;
                }
                case Division: {
                    return a / b;
                }
                case Modulo: {
                    return a % b;
                }
                case Power: {
                    return Math.pow(a, b);
                }
            }
            return a + b;
        }

        public static Operator get(String name) {
            for (Operator operator : Operator.values()) {
                if (!operator.name().equalsIgnoreCase(name)) continue;
                return operator;
            }
            return Addition;
        }
    }

    public static enum Mode {
        None,
        Round,
        Floor,
        Ceiling;


        public String perform(double in) {
            switch (this) {
                case Floor: {
                    return String.valueOf((int)Math.floor(in));
                }
                case Round: {
                    return String.valueOf((int)Math.round(in));
                }
                case Ceiling: {
                    return String.valueOf((int)Math.ceil(in));
                }
            }
            return String.valueOf(in);
        }

        public static Mode get(String name) {
            for (Mode mode : Mode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return None;
        }
    }
}

