/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityVicinityObjective
implements IObjective {
    @Override
    public String identifier() {
        return "TILEENTITY_VICINITY";
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("tile_entity", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("range", false, false, ArgumentType.WHOLE_NUMBER, new String[0]));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> s), Argument.from(args.get(1), Integer::parseInt));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        BlockEntity te;
        String type = (String)arguments.value(0, progress);
        int distance = (Integer)arguments.value(1, progress);
        ServerLevel world = data.getPlayer().m_284548_();
        Iterator<BlockEntity> iterator = this.getTileEntitiesWithinAABB((Level)world, data.getPlayer().m_20191_().m_82363_((double)distance, (double)distance, (double)distance)).iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            te = iterator.next();
        } while (!(data.getPlayer().m_20275_((double)te.m_58899_().m_123341_(), (double)te.m_58899_().m_123342_(), (double)te.m_58899_().m_123343_()) <= (double)(distance * distance)) || !ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)te.m_58903_()).toString().equals(type));
        return true;
    }

    private List<BlockEntity> getTileEntitiesWithinAABB(Level world, AABB aabb) {
        int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
        int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
        int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
        int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                if (world.m_7726_().m_62227_(j3, k3, false) == null) continue;
                list.addAll(world.m_6325_(j3, k3).m_62954_().values());
            }
        }
        return list;
    }
}

