/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.UUIDHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.player.ItemObjective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class NPCObjective
implements IObjective {
    private final String identifier;
    private final Type type;

    public NPCObjective(String identifier, Type type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public QuestElement getStructure() {
        if (this.type == Type.TALK) {
            return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", false, false, ArgumentType.TEXT, new String[0]));
        }
        if (this.type == Type.RESPOND) {
            return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("dialogue_option", false, false, ArgumentType.WHOLE_NUMBER, "0", "1", "2", "3", "4", "5", "6", "7"));
        }
        if (this.type == Type.GIVE || this.type == Type.SHOW) {
            return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("success", false, false, ArgumentType.SUCCESS, new String[0]), new QuestElementArgument("item", false, false, ArgumentType.ITEM, new String[0]), new QuestElementArgument("count", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("damage_metadata", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("display_name", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("nbt", true, false, ArgumentType.TEXT, new String[0]));
        }
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument[0]);
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        if (this.type == Type.GIVE || this.type == Type.SHOW) {
            return Arguments.create(Argument.of(this.type), Argument.from(args.get(0), UUIDHelper::questUUID), Argument.from(args.get(1), s -> s.equalsIgnoreCase("success") || s.equalsIgnoreCase("true"), true), Argument.from(args.get(2), s -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(s)), null), Argument.from(args.get(3), Integer::parseInt, -1), Argument.from(args.get(4), Integer::parseInt, -1), Argument.from(args.get(5), s -> s, ""), Argument.from(args.get(6), s -> {
                try {
                    return TagParser.m_129359_((String)s);
                }
                catch (Exception e) {
                    return new CompoundTag();
                }
            }, new CompoundTag()));
        }
        if (this.type == Type.RESPOND) {
            return Arguments.create(Argument.of(this.type), Argument.from(args.get(0), UUIDHelper::questUUID), Argument.from(args.get(1), Integer::parseInt, 1));
        }
        return Arguments.create(Argument.of(this.type), Argument.from(args.get(0), UUID::fromString));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        Entity npc = (Entity)context.get(0);
        Type type = (Type)((Object)arguments.value(0, progress));
        UUID uuid = (UUID)arguments.value(1, progress);
        if (uuid == null || !npc.m_20148_().equals(uuid)) {
            return false;
        }
        switch (type) {
            case GIVE: 
            case SHOW: {
                Inventory inventory = data.getPlayer().m_150109_();
                boolean success = (Boolean)arguments.value(2, progress);
                Item item = (Item)arguments.value(3, progress);
                int count = (Integer)arguments.value(4, progress);
                int damage = (Integer)arguments.value(5, progress);
                String name = (String)arguments.value(6, progress);
                CompoundTag nbt = (CompoundTag)arguments.value(7, progress);
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack stack = inventory.m_8020_(i);
                    if (stack.m_41619_() || !ItemObjective.compare(stack, item, count, damage, name, nbt)) continue;
                    if (type == Type.GIVE) {
                        stack.m_41774_(count);
                    }
                    return success;
                }
                return !success;
            }
            case RESPOND: {
                int a = (Integer)context.get(1);
                int b = (Integer)arguments.value(2, progress);
                if (a != b) break;
                return true;
            }
            case TALK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stage, QuestProgress progress, Objective objective, int objectiveIndex, Arguments arguments, Context context) {
        UUID uuid;
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        if (!progress.isObjectiveComplete(objectiveIndex) && (uuid = (UUID)arguments.value(1, progress)) != null) {
            markers.add(new QuestMarker(uuid, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocationHelper.of("minecraft:overworld")), progress.getQuest().getColor(), progress.getMarkerType()));
        }
        return markers;
    }

    public static enum Type {
        TALK,
        GIVE,
        SHOW,
        RESPOND;

    }
}

