/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.pixelmonmod.pixelmon.api.util.helpers.UUIDHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class EntityInteractObjective
implements IObjective {
    @Override
    public int quantity(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments) {
        return arguments.quantity(1, progress);
    }

    @Override
    public String identifier() {
        return "ENTITY_INTERACT";
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid_class", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("count", false, false, ArgumentType.WHOLE_NUMBER, new String[0]));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> s), Argument.from(args.get(1), Integer::parseInt));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        Entity entity = (Entity)context.get(0);
        String uuidOrType = (String)arguments.value(0, progress);
        if (UUIDHelper.isUUID(uuidOrType)) {
            UUID uuid = UUID.fromString(uuidOrType);
            return entity.m_20148_().equals(uuid);
        }
        return entity.getClass().getSimpleName().equalsIgnoreCase(uuidOrType);
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stage, QuestProgress progress, Objective objective, int objectiveIndex, Arguments arguments, Context context) {
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        String uuidOrType = (String)arguments.value(0, progress);
        if (UUIDHelper.isUUID(uuidOrType)) {
            markers.add(new QuestMarker(UUID.fromString(uuidOrType), (ResourceKey<Level>)Level.f_46428_, progress.getQuest().getColor(), progress.getMarkerType()));
        }
        return markers;
    }
}

