/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.events.BeatTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.LostToTrainerEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonTradeEvent;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerListeners {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            if ((pps.getMegaItemsUnlocked().canMega() || pps.getMegaItemsUnlocked().canDynamax()) && pps.getMegaItem() == EnumMegaItem.Disabled) {
                pps.setMegaItem(EnumMegaItem.None, false);
            }
            QuestData data = pps.getQuestData(true);
            for (QuestProgress progress : data.getProgress()) {
                progress.sendTo(player);
            }
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) throws InvalidQuestArgsException {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(true).receive("DIMENSION", new Object[0]);
        }
    }

    @SubscribeEvent
    public void onDefeatTrainer(BeatTrainerEvent event) throws InvalidQuestArgsException {
        PlayerPartyStorage pps = StorageProxy.getPartyNow(event.player);
        pps.getQuestData(true).receive("TRAINER_DEFEAT", new Object[]{event.trainer});
    }

    @SubscribeEvent
    public void onLoseToTrainer(LostToTrainerEvent event) throws InvalidQuestArgsException {
        PlayerPartyStorage pps = StorageProxy.getPartyNow(event.player);
        pps.getQuestData(true).receive("TRAINER_DEFEATED_BY", new Object[]{event.trainer});
    }

    @SubscribeEvent
    public void onPlayerTrade(PixelmonTradeEvent.Post event) throws InvalidQuestArgsException {
        if (event.getPlayer1() instanceof ServerPlayer) {
            ServerPlayer p1 = (ServerPlayer)event.getPlayer1();
            ServerPlayer p2 = (ServerPlayer)event.getPlayer2();
            PlayerPartyStorage pps1 = StorageProxy.getPartyNow(p1);
            PlayerPartyStorage pps2 = StorageProxy.getPartyNow(p2);
            pps1.getQuestData(false).receive("POKEMON_TRADE_GIVE", event.getPokemon1());
            pps1.getQuestData(true).receive("POKEMON_TRADE_GET", event.getPokemon2());
            pps2.getQuestData(false).receive("POKEMON_TRADE_GET", event.getPokemon2());
            pps2.getQuestData(true).receive("POKEMON_TRADE_GIVE", event.getPokemon1());
        }
    }
}

