/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.events.ApricornEvent;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ItemListeners {
    @SubscribeEvent
    public void onApricornHarvest(ApricornEvent.Pick event) throws InvalidQuestArgsException {
        ServerPlayer player = event.getPlayer();
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        pps.getQuestData(false).receive("APRICORN_HARVEST", event.getPickedStack());
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickItem event) throws InvalidQuestArgsException {
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == InteractionHand.MAIN_HAND) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(false).receive("ITEM_USE", event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onPickupItem(PlayerEvent.ItemPickupEvent event) throws InvalidQuestArgsException {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(false).receive("ITEM_PICKUP", event.getStack());
        }
    }

    @SubscribeEvent
    public void onDropItem(ItemTossEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(false).receive("ITEM_DROP", event.getEntity().m_32055_());
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) throws InvalidQuestArgsException {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(true).receive("ITEM_CRAFT", event.getCrafting());
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) throws InvalidQuestArgsException {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(true).receive("ITEM_SMELT", event.getSmelting());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws InvalidQuestArgsException {
        if (event.player instanceof ServerPlayer && event.player.f_19853_ != null && event.player.f_19853_.m_46467_() % 40L == 0L) {
            ServerPlayer player = (ServerPlayer)event.player;
            Inventory inventory = player.m_150109_();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            QuestData data = pps.getQuestData(false);
            ArrayList items = new ArrayList(inventory.f_35974_);
            data.receiveMultipleInternal(new String[]{"ITEM_HAS", "ITEM_HAS_NOT"}, new Object[][]{{items}, {items}}, false);
        }
    }
}

