/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.EggHatchEvent;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.events.LostToWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonKnockoutEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class EntityListeners {
    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) throws InvalidQuestArgsException {
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == InteractionHand.MAIN_HAND) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            QuestData questData = StorageProxy.getPartyNow(player).getQuestData(true);
            questData.receiveInternal("DIALOGUE", true, event.getTarget(), null);
            questData.receive("ENTITY_INTERACT", event.getTarget());
        }
    }

    @SubscribeEvent
    public void onNPCChat(NPCChatEvent event) throws InvalidQuestArgsException {
        if (event.player instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.player;
            StorageProxy.getPartyNow(player).getQuestData(true).receiveInternal("DIALOGUE", true, new Object[]{event.npc, event});
        }
    }

    @SubscribeEvent
    public void onPixelmonSpawn(SpawnEvent event) throws InvalidQuestArgsException {
        if (event.action.spawnLocation.cause instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.action.spawnLocation.cause;
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            QuestData data = pps.getQuestData(false);
            data.receive("NPC_SPAWN_INSERTER", event.action.getOrCreateEntity());
        }
    }

    @SubscribeEvent
    public void onEvolve(EvolveEvent.Pre event) throws InvalidQuestArgsException {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        pps.getQuestData(true).receive("POKEMON_EVOLVE_PRE", event.getPokemon());
    }

    @SubscribeEvent
    public void onEvolve(EvolveEvent.Post event) throws InvalidQuestArgsException {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        pps.getQuestData(true).receive("POKEMON_EVOLVE_POST", event.getPokemon());
    }

    @SubscribeEvent
    public void onEggHatch(EggHatchEvent.Post event) throws InvalidQuestArgsException {
        ServerPlayer player = event.getPokemon().getOwnerPlayer();
        if (player == null) {
            return;
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        pps.getQuestData(true).receive("POKEMON_HATCH", event.getPokemon());
    }

    @SubscribeEvent
    public void onWildCapture(CaptureEvent.SuccessfulCapture event) throws InvalidQuestArgsException {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        pps.getQuestData(true).receive("POKEMON_CAPTURE", event.getPokemon().getPokemon());
    }

    @SubscribeEvent
    public void onKnockout(PixelmonKnockoutEvent event) throws InvalidQuestArgsException {
        ServerPlayer player = event.source.getPlayerOwner();
        if (player != null) {
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            QuestData data = pps.getQuestData(true);
            Pokemon pokemon = event.pokemon.getInnerLink();
            data.receive("POKEMON_DEFEAT", pokemon);
            if (event.pokemon.getTrainerOwner() != null) {
                data.receive("POKEMON_DEFEAT_NPC", pokemon);
            } else if (event.pokemon.getPlayerOwner() != null) {
                data.receive("POKEMON_DEFEAT_PLAYER", pokemon);
            }
        }
    }

    @SubscribeEvent
    public void onDefeatWild(BeatWildPixelmonEvent event) throws InvalidQuestArgsException {
        if (event.player == null) {
            return;
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(event.player);
        QuestData data = pps.getQuestData(true);
        for (PixelmonWrapper pw : event.wpp.allPokemon) {
            data.receive("POKEMON_DEFEAT_WILD", pw.pokemon);
        }
    }

    @SubscribeEvent
    public void onLoseToWild(LostToWildPixelmonEvent event) throws InvalidQuestArgsException {
        ServerPlayer player = event.player;
        if (player != null) {
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            for (PixelmonWrapper pw : event.wpp.getActiveUnfaintedPokemon()) {
                pps.getQuestData(true).receive("POKEMON_DEFEATED_BY", pw.getInnerLink());
            }
        }
    }
}

