/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class BlockListeners {
    @SubscribeEvent
    public void onBlockUse(PlayerInteractEvent.RightClickBlock event) throws InvalidQuestArgsException {
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == InteractionHand.MAIN_HAND) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            BlockState state = player.m_9236_().m_8055_(event.getPos());
            pps.getQuestData(false).receive("BLOCK_USE", new ItemStack((ItemLike)state.m_60734_()), state.m_60734_());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            BlockState state = event.getState();
            ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
            if (stack.m_41619_()) {
                stack = state.m_60734_() instanceof RedStoneOreBlock ? new ItemStack((ItemLike)Blocks.f_50173_) : new ItemStack((ItemLike)state.m_60734_().m_49966_().m_60734_());
            }
            pps.getQuestData(false).receive("BLOCK_BREAK", stack, state.m_60734_());
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) throws InvalidQuestArgsException {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            BlockState state = event.getState();
            pps.getQuestData(false).receive("BLOCK_PLACE", new ItemStack((ItemLike)state.m_60734_()), state.m_60734_());
        }
    }
}

