/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.editor.args;

import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;

public class QuestElementArgument {
    private String name;
    private boolean optional;
    private boolean string;
    private ArgumentType type;
    private String[] options;
    private String currentValue = "-";

    public QuestElementArgument(String name, boolean optional, boolean string, ArgumentType type, String ... options) {
        this.name = name;
        this.optional = optional;
        this.string = string;
        this.type = type;
        this.options = options;
        if (this.options.length == 0) {
            if (type == ArgumentType.BOOLEAN) {
                this.options = new String[]{"true", "false"};
            } else if (type == ArgumentType.SUCCESS) {
                this.options = new String[]{"success", "failure"};
            }
        }
    }

    public QuestElementArgument(FriendlyByteBuf buf) {
        this.readFromByteBuf(buf);
    }

    public QuestElementArgument copy() {
        String[] options = new String[this.options.length];
        System.arraycopy(this.options, 0, options, 0, options.length);
        return new QuestElementArgument(this.name, this.optional, this.string, this.type, options);
    }

    public String getName() {
        String langKey = "quest.argument." + this.name;
        return I18n.m_118936_((String)langKey) ? I18n.m_118938_((String)langKey, (Object[])new Object[0]) : this.name;
    }

    public String getCurrentValue() {
        return this.currentValue.isEmpty() ? "-" : (this.type == ArgumentType.TEXT ? this.currentValue.replace("_", " ") : this.currentValue);
    }

    public String getTrueCurrentValue() {
        return this.currentValue;
    }

    public boolean isString() {
        return this.string;
    }

    public void setCurrentValue(String value) {
        String string = this.currentValue = value.isEmpty() ? "-" : value;
        if (this.type == ArgumentType.TEXT) {
            this.currentValue = this.currentValue.replace(" ", "_");
        }
    }

    public boolean isEmpty() {
        return this.currentValue.isEmpty() || this.currentValue.equalsIgnoreCase("-");
    }

    public boolean isValid() {
        if (this.isEmpty() && (this.optional || this.string)) {
            return true;
        }
        if (this.options.length > 0) {
            for (String option : this.options) {
                if (!option.equalsIgnoreCase(this.currentValue)) continue;
                return true;
            }
            return false;
        }
        return this.type.isValidInput(this.currentValue);
    }

    public String[] getOptions() {
        return this.options;
    }

    public void readFromByteBuf(FriendlyByteBuf buf) {
        this.name = buf.m_130277_();
        this.optional = buf.readBoolean();
        this.string = buf.readBoolean();
        this.type = ArgumentType.values()[buf.readByte()];
        this.options = new String[buf.readShort()];
        for (int i = 0; i < this.options.length; ++i) {
            this.options[i] = buf.m_130277_();
        }
        this.currentValue = buf.m_130277_();
    }

    public void writeToByteBuf(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.writeBoolean(this.optional);
        buf.writeBoolean(this.string);
        buf.writeByte(this.type.ordinal());
        buf.writeShort(this.options.length);
        for (String option : this.options) {
            buf.m_130070_(option);
        }
        buf.m_130070_(this.currentValue);
    }
}

