/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm.editor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.QuestEditorItem;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.ResetQuestsPacket;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ReloadQuestDataPacket
extends AbstractPixelmonPacket {
    public ReloadQuestDataPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (QuestEditorItem.checkPermission((Player)player)) {
            try {
                for (ServerPlayer playerMP : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                    NetworkHelper.sendPacket(new ResetQuestsPacket(), playerMP);
                    PlayerPartyStorage pps = StorageProxy.getPartyNow(playerMP);
                    QuestData data = pps.getQuestData();
                    for (QuestProgress progress : data.getProgress()) {
                        progress.invalidate();
                        progress.getQuest();
                        progress.sendTo(playerMP);
                    }
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error(e.toString());
            }
        }
    }
}

