/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm.editor;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PullQuestDataPacket
extends AbstractPixelmonPacket {
    private ArrayList<Quest> quests = new ArrayList<Quest>(QuestRegistry.getInstance().getQuestCollection());
    private ArrayList<QuestElement> elements = QuestRegistry.getInstance().getQuestElements();

    public PullQuestDataPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeShort(this.quests.size());
        for (Quest quest : this.quests) {
            quest.writeToByteBuf(buf);
        }
        buf.writeShort(this.elements.size());
        for (QuestElement element : this.elements) {
            element.writeToByteBuf(buf);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.quests = new ArrayList();
        int questCount = buf.readShort();
        for (int i = 0; i < questCount; ++i) {
            this.quests.add(new Quest(buf));
        }
        this.elements = new ArrayList();
        int elementCount = buf.readShort();
        for (int i = 0; i < elementCount; ++i) {
            this.elements.add(new QuestElement(buf));
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        QuestEditorState.get().setQuests(this.quests, this.elements);
    }
}

