/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm.editor;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.QuestEditorItem;
import com.pixelmonmod.pixelmon.quests.comm.editor.PullQuestDataPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class FetchQuestDataPacket
extends AbstractPixelmonPacket {
    private boolean openGui;

    public FetchQuestDataPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public FetchQuestDataPacket(boolean openGui) {
        super(PacketDirection.PLAY_SERVER, true);
        this.openGui = openGui;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.openGui);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.openGui = buf.readBoolean();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (QuestEditorItem.checkPermission((Player)player)) {
            NetworkHelper.sendPacket(new PullQuestDataPacket(), player);
            if (this.openGui) {
                OpenScreenPacket.open((Player)player, EnumGuiScreen.QuestEditor, new int[0]);
            }
        }
    }
}

