/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm;

import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class QuestMarker {
    public float x;
    public float y;
    public float z;
    public UUID uuid;
    public ResourceKey<Level> dim;
    public boolean specialColor;
    public QuestColor color;
    public Type type;

    public QuestMarker(float x, float y, float z, UUID uuid, ResourceKey<Level> dim, QuestColor color, Type type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.uuid = uuid;
        this.dim = dim;
        this.color = color;
        this.type = type;
    }

    public QuestMarker(BlockPos pos, UUID uuid, ResourceKey<Level> dim, QuestColor color, Type type) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), uuid, dim, color, type);
    }

    public QuestMarker(double x, double y, double z, UUID uuid, ResourceKey<Level> dim, QuestColor color, Type type) {
        this((float)x, (float)y, (float)z, uuid, dim, color, type);
    }

    public QuestMarker(float x, float y, float z, ResourceKey<Level> dim, QuestColor color, Type type) {
        this(x, y, z, (UUID)null, dim, color, type);
    }

    public QuestMarker(UUID uuid, ResourceKey<Level> dim, QuestColor color, Type type) {
        this(0.0f, 0.0f, 0.0f, uuid, dim, color, type);
    }

    public QuestMarker(BlockPos pos, ResourceKey<Level> dim, QuestColor color, Type type) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (UUID)null, dim, color, type);
    }

    public QuestMarker(double x, double y, double z, ResourceKey<Level> dim, QuestColor color, Type type) {
        this((float)x, (float)y, (float)z, (UUID)null, dim, color, type);
    }

    public QuestMarker(FriendlyByteBuf buf) {
        this.read(buf);
    }

    public void read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.uuid = buf.m_130259_();
        } else {
            this.x = buf.readFloat();
            this.y = buf.readFloat();
            this.z = buf.readFloat();
        }
        this.dim = buf.m_236801_(Registries.f_256858_);
        this.specialColor = buf.readBoolean();
        this.color = this.specialColor ? new QuestColor(buf.readInt(), 0, 0) : new QuestColor(buf.readInt());
        this.type = Type.values()[buf.readByte()];
    }

    public void write(FriendlyByteBuf buf) {
        if (this.uuid != null) {
            buf.writeBoolean(true);
            buf.m_130077_(this.uuid);
        } else {
            buf.writeBoolean(false);
            buf.writeFloat(this.x);
            buf.writeFloat(this.y);
            buf.writeFloat(this.z);
        }
        buf.m_236858_(this.dim);
        buf.writeBoolean(this.color.getR() < 0);
        buf.writeInt(this.color.getR() < 0 ? this.color.getR() : this.color.getRGB());
        buf.writeByte(this.type.ordinal());
    }

    public QuestColor getColor(long worldTime) {
        if (this.specialColor && this.color.getR() == -1) {
            long mod = worldTime % 120L;
            if (mod > 60L) {
                mod -= (mod - 60L) * 2L;
            }
            mod = (int)((double)mod * 1.5);
            return new QuestColor(28, 65 + (int)mod, 138);
        }
        return this.color;
    }

    public static enum Type {
        EXCLAMATION,
        QUESTION;

    }
}

