/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AbandonQuestPacket
extends AbstractPixelmonPacket {
    private String filename;
    private UUID identifier;

    public AbandonQuestPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public AbandonQuestPacket(QuestProgressClient qpc) {
        super(PacketDirection.PLAY_SERVER, true);
        this.filename = qpc.getFilename();
        this.identifier = qpc.getIdentifier();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.filename);
        buf.m_130077_(this.identifier);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.filename = buf.m_130277_();
        this.identifier = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
            pps.getQuestData(true).abandonQuest(this.filename, this.identifier);
        }
    }
}

