/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.ui.GuiListQuest;
import com.pixelmonmod.pixelmon.quests.comm.AbandonQuestPacket;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class GuiQuests
extends Screen {
    private Button random;
    private Button craft;
    private GuiListQuest questList;
    private GuiListQuest completeList;
    private boolean showActive = true;
    private int activeSeperator = 25;
    private boolean init = false;
    private boolean abandoning = false;
    private int abandonColor = -5767168;
    private boolean rising = true;

    public GuiQuests() {
        super((Component)Component.m_237119_());
    }

    public void m_7856_() {
        this.m_169413_();
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        this.questList = new GuiListQuest(this.f_96541_.f_91062_, x + 7, y + 23, 104, 9);
        this.completeList = new GuiListQuest(this.f_96541_.f_91062_, x + 7, y + 27, 104, 9);
        this.refreshQuests();
        this.questList.m_93692_(true);
    }

    public void refreshQuests() {
        this.questList.lines.clear();
        this.completeList.lines.clear();
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getQuests()) {
            if (qpc.getName() == null) continue;
            this.questList.addLine(qpc);
        }
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getCompleteQuests()) {
            this.completeList.addLine(qpc);
        }
        this.questList.selectQuest(-1);
        this.completeList.selectQuest(-1);
    }

    public void m_280273_(GuiGraphics p_230446_1_, int mouseX, int mouseY, float pratialTicks) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int sliderSpeed = 5;
        if (mouseX >= (double)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 1) && mouseX <= (double)((int)((float)x + 3.0f * (float)dispWidth / 4.0f)) && mouseY >= (double)(y + lowerBorder - div) && mouseY <= (double)(y + dispHeight - div)) {
            QuestProgressClient selectedQuest = null;
            if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1) {
                selectedQuest = this.questList.lines.get(this.questList.selectedQuest);
            }
            if (selectedQuest != null) {
                boolean openEye;
                boolean bl = openEye = QuestDataClient.getInstance().getDisplayQuest() != selectedQuest;
                if (openEye) {
                    QuestDataClient.getInstance().setDisplayQuest(selectedQuest);
                } else {
                    QuestDataClient.getInstance().setDisplayQuest(null);
                }
            }
        } else {
            QuestProgressClient clickedOnQuest;
            if (mouseX >= (double)v && mouseX <= (double)(x + dispWidth - 2) && mouseY >= (double)(y + lowerBorder - div) && mouseY <= (double)(y + dispHeight - div)) {
                QuestProgressClient selectedQuest;
                if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1 && (selectedQuest = this.questList.lines.get(this.questList.selectedQuest)).isAbandonable()) {
                    if (!this.abandoning) {
                        this.questList.scrollUp();
                        this.completeList.scrollUp();
                        this.abandoning = true;
                    } else {
                        if (QuestDataClient.getInstance().getDisplayQuest() == selectedQuest) {
                            QuestDataClient.getInstance().setDisplayQuest(null);
                        }
                        NetworkHelper.sendToServer(new AbandonQuestPacket(selectedQuest));
                    }
                }
                return true;
            }
            if (this.activeSeperator == border && mouseX > (double)(x - gap) && mouseX < (double)(x - gap + dispWidth / 2) && mouseY > (double)y && mouseY < (double)(y + this.activeSeperator) && !this.showActive) {
                this.showActive = true;
                this.questList.m_93692_(true);
                this.completeList.m_93692_(false);
            } else if (this.activeSeperator == lowerBorder && mouseX > (double)(x - gap) && mouseX < (double)(x - gap + dispWidth / 2) && mouseY > (double)(y + this.activeSeperator + div) && mouseY < (double)(y + dispHeight) && this.showActive) {
                this.showActive = false;
                this.completeList.m_93692_(true);
                this.questList.m_93692_(false);
            } else if (this.questList.isFocused) {
                QuestProgressClient clickedOnQuest2 = this.questList.mouseClicked(mouseX, mouseY, 0, this.questList.yPos + 8);
                if (clickedOnQuest2 != null) {
                    int lineindex = this.questList.lines.indexOf(clickedOnQuest2);
                    this.completeList.selectQuest(-1);
                    this.questList.selectQuest(lineindex);
                }
            } else if (this.completeList.isFocused && (clickedOnQuest = this.completeList.mouseClicked(mouseX, mouseY, 0, this.completeList.yPos + 8)) != null) {
                int lineindex = this.completeList.lines.indexOf(clickedOnQuest);
                this.questList.selectQuest(-1);
                this.completeList.selectQuest(lineindex);
            }
        }
        this.abandoning = false;
        return true;
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float f) {
        int qlh;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        super.m_88315_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        if (!this.init) {
            this.activeSeperator = dispHeight - border - div;
        }
        int sliderSpeed = 5;
        if (!this.showActive) {
            if (this.activeSeperator > border) {
                this.activeSeperator -= sliderSpeed;
                if (this.activeSeperator <= border) {
                    this.activeSeperator = border;
                }
            }
        } else if (this.activeSeperator < lowerBorder) {
            this.activeSeperator += sliderSpeed;
            if (this.activeSeperator >= lowerBorder) {
                this.activeSeperator = lowerBorder;
            }
        }
        if ((qlh = this.activeSeperator - border - 12) <= 2) {
            this.questList.isEnabled = false;
        } else {
            this.questList.isEnabled = true;
            this.questList.height = qlh;
            this.questList.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        }
        float titleBorder = 8.5f;
        int clh = lowerBorder - 12 - this.activeSeperator;
        this.completeList.yPos = y + (int)titleBorder + this.activeSeperator + div + 16;
        if (clh <= 2) {
            this.completeList.isEnabled = false;
        } else {
            this.completeList.isEnabled = true;
            this.completeList.height = clh;
            this.completeList.displayLines = (int)(9.0f * ((float)clh / (float)(lowerBorder - 12 - border)));
        }
        matrix.m_280163_(Resources.backgroundTexture, x - gap, y, 0.0f, 0.0f, dispWidth / 2, this.activeSeperator, (int)((float)dispWidth / 2.0f), this.activeSeperator);
        matrix.m_280163_(Resources.backgroundTexture, x - gap, y + this.activeSeperator + div, 0.0f, 0.0f, dispWidth / 2, dispHeight - div - this.activeSeperator, (int)((float)dispWidth / 2.0f), dispHeight - div - this.activeSeperator);
        matrix.m_280163_(Resources.backgroundTexture, x + dispWidth / 2 + gap + 1, y, 0.0f, 0.0f, dispWidth / 2, dispHeight, (int)((float)dispWidth / 2.0f), dispHeight);
        String textA = ChatFormatting.BOLD + I18n.m_118938_((String)"quest.ui.quests", (Object[])new Object[0]);
        matrix.drawString(this.f_96547_, textA, (float)(x - gap + dispWidth / 4 - this.f_96547_.m_92895_(textA) / 2), (float)y + titleBorder, 0xFFFFFF, true);
        String textB = ChatFormatting.BOLD + I18n.m_118938_((String)"quest.ui.history", (Object[])new Object[0]);
        matrix.drawString(this.f_96547_, textB, (float)(x - gap + dispWidth / 4 - this.f_96547_.m_92895_(textB) / 2), (float)y + titleBorder + (float)this.activeSeperator + (float)div, 0xFFFFFF, true);
        if (this.questList.isEnabled) {
            this.questList.drawBackground(matrix);
            this.questList.drawText(matrix);
        }
        if (this.completeList.isEnabled) {
            this.completeList.drawBackground(matrix);
            this.completeList.drawText(matrix);
        }
        QuestProgressClient selectedQuest = null;
        if (this.questList.selectedQuest != null && this.questList.selectedQuest != -1) {
            selectedQuest = this.questList.lines.get(this.questList.selectedQuest);
        } else if (this.completeList.selectedQuest != null && this.completeList.selectedQuest != -1) {
            selectedQuest = this.completeList.lines.get(this.completeList.selectedQuest);
        }
        if (selectedQuest != null) {
            String title = selectedQuest.getName();
            String desc = selectedQuest.getDesc();
            int width = (int)((float)dispWidth / 2.0f - 9.0f);
            int descHeight = this.f_96547_.m_92920_(desc, width);
            int strWidth = this.f_96547_.m_92895_(title);
            double wf = 95.0;
            double finalWidth = Math.min((double)strWidth, wf - 6.0);
            ScreenHelper.drawSquashedString(matrix, this.f_96547_, title, false, (float)wf, (float)((int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0 + 6.0)), (float)((int)((float)y + titleBorder)), 0xFFFFFF, true);
            ScreenHelper.drawSplitString(matrix, desc, (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f), (int)((float)y + titleBorder + 17.0f), width, 0xFFFFFF);
            for (ObjectiveDetail od : selectedQuest.getObjectives()) {
                int channel = 5;
                String detail = selectedQuest.format(od);
                if (detail.isEmpty()) continue;
                int detailHeight = this.f_96547_.m_92920_(detail, width - channel);
                int n = (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + channel;
                int n2 = (int)((float)y + titleBorder + 14.0f) + descHeight;
                Objects.requireNonNull(this.f_96547_);
                ScreenHelper.drawSplitString(matrix, detail, n, n2 + 9, width - channel, 0xFFFFFF);
                descHeight += detailHeight;
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            if (selectedQuest.isComplete()) {
                matrix.m_280246_(0.8509804f, 0.8509804f, 0.8509804f, 1.0f);
            } else {
                QuestColor color = selectedQuest.getColor();
                matrix.m_280246_(color.floatR(), color.floatG(), color.floatB(), 1.0f);
            }
            matrix.m_280163_(selectedQuest.isComplete() ? Resources.question_mark : selectedQuest.getIcon().getResource(), (int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0) - 11, (int)((float)y + titleBorder) - 4, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int inactiveButtonColor = -9079435;
        boolean openEye = selectedQuest == null || QuestDataClient.getInstance().getDisplayQuest() != selectedQuest;
        matrix.m_280509_((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 1, y + lowerBorder - div, (int)((float)x + 3.0f * (float)dispWidth / 4.0f), y + dispHeight - div, selectedQuest == null || selectedQuest.isComplete() ? inactiveButtonColor : (openEye ? -12884481 : -10467329));
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int resting = -5767168;
        int alerting = -1179648;
        int diff = 65536;
        if (this.abandoning) {
            if (this.rising) {
                this.abandonColor += diff;
                if (this.abandonColor >= alerting) {
                    this.rising = false;
                }
            } else {
                this.abandonColor -= diff;
                if (this.abandonColor <= resting) {
                    this.rising = true;
                }
            }
        } else if (this.abandonColor > resting) {
            this.abandonColor -= diff;
            if (this.abandonColor <= resting) {
                this.abandonColor = resting;
            }
        } else {
            this.abandonColor = resting;
        }
        matrix.m_280509_((int)v, y + lowerBorder - div, x + dispWidth - 2, y + dispHeight - div, selectedQuest == null || selectedQuest.isComplete() || !selectedQuest.isAbandonable() ? inactiveButtonColor : this.abandonColor);
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 0.8f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.m_280163_(openEye ? Resources.eyeTexture : Resources.eyeClosedTexture, (int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 11, (int)((float)(y + lowerBorder) - (float)div * 1.55f), 0.0f, 0.0f, 32, 32, 32, 32);
        matrix.m_280163_(Resources.crossTexture, (int)v + 11, (int)((float)(y + lowerBorder) - (float)div * 1.55f), 0.0f, 0.0f, 32, 32, 32, 32);
        String leftButton = openEye ? I18n.m_118938_((String)"quest.ui.track", (Object[])new Object[0]) : I18n.m_118938_((String)"quest.ui.hide", (Object[])new Object[0]);
        matrix.drawString(this.f_96547_, leftButton, (float)((int)((float)(x + gap * 3) + (float)dispWidth / 2.0f) + 27) - (float)this.f_96547_.m_92895_(leftButton) / 2.0f, (float)((int)((float)(y + lowerBorder) - (float)div * 1.55f) + 26), 0xFFFFFF, true);
        String rightButton = this.abandoning ? I18n.m_118938_((String)"quest.ui.abandoncheck", (Object[])new Object[0]) : I18n.m_118938_((String)"quest.ui.abandon", (Object[])new Object[0]);
        matrix.drawString(this.f_96547_, rightButton, (float)((int)v + 27) - (float)this.f_96547_.m_92895_(rightButton) / 2.0f, (float)((int)((float)(y + lowerBorder) - (float)div * 1.55f) + 26), 0xFFFFFF, true);
        if (!this.init) {
            this.init = true;
        }
    }

    public boolean m_6050_(double p_231043_1_, double p_231043_3_, double deltaX, double deltaY) {
        if (deltaY == 1.0) {
            if (this.questList.isFocused) {
                this.questList.scrollDown();
            } else if (this.completeList.isFocused) {
                this.completeList.scrollDown();
            }
        } else if (deltaY == -1.0) {
            if (this.questList.isFocused) {
                this.questList.scrollUp();
            } else if (this.completeList.isFocused) {
                this.completeList.scrollUp();
            }
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
    }
}

