/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.KeybindIcon;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class GuiKeybindIconQuest
extends KeybindIcon {
    private final KeyMapping keybindA;
    private final KeyMapping keybindB;
    private boolean enabled = true;

    public GuiKeybindIconQuest(KeyMapping keybindA, KeyMapping keybindB) {
        super(null, null);
        this.keybindA = keybindA;
        this.keybindB = keybindB;
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, float zLevel) {
        if (this.enabled) {
            float[] rgba;
            ResourceLocation rl;
            ScreenHelper.drawString(graphics, StringUtils.capitalize((String)this.keybindA.getKey().m_84875_().getString()), x + 20, (float)(y + 17), 0xFFFFFF, false, true);
            ScreenHelper.drawString(graphics, StringUtils.capitalize((String)this.keybindB.getKey().m_84875_().getString()), x + 20, (float)(y - 5), 0xFFFFFF, false, true);
            boolean drawnArrow = false;
            PoseStack matrix = graphics.m_280168_();
            QuestProgressClient qpc = QuestDataClient.getInstance().getDisplayQuest();
            if (qpc != null && qpc.getObjectives() != null) {
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.enableBlend();
                String name = qpc.getName();
                ScreenHelper.drawStringRightAligned(graphics, name, x - 3, y + 1, 0xFFFFFF, true, true);
                matrix.m_85836_();
                matrix.m_85837_(-0.5, 0.0, 0.0);
                ScreenHelper.drawStringRightAligned(graphics, name, x - 3, y + 1, 0xFFFFFF, true, true);
                matrix.m_85849_();
                if (qpc.getObjectives() != null) {
                    for (ObjectiveDetail od : qpc.getObjectives()) {
                        String detail;
                        if (od.isComplete() || (detail = qpc.format(od)).isEmpty()) continue;
                        ScreenHelper.drawStringRightAligned(graphics, detail, x - 3, y + 9, 0xFFFFFF, false, true);
                        break;
                    }
                }
                ResourceLocation resourceLocation = rl = qpc.isComplete() ? Resources.question_mark : qpc.getIcon().getResource();
                if (qpc.isComplete() || qpc.getColor() == null) {
                    rgba = new float[]{0.8509804f, 0.8509804f, 0.8509804f, 1.0f};
                } else {
                    QuestColor color = qpc.getColor();
                    rgba = new float[]{color.floatR(), color.floatG(), color.floatB(), 1.0f};
                }
                for (QuestMarker marker : qpc.getMarkers()) {
                    if (!this.drawArrow(graphics, marker, x - 1, y + 1, zLevel, rgba)) continue;
                    drawnArrow = true;
                    break;
                }
            } else {
                rl = Resources.exclamation_mark;
                rgba = new float[]{0.8509804f, 0.8509804f, 0.8509804f, 1.0f};
            }
            if (!drawnArrow) {
                ScreenHelper.drawImageQuad(rl, graphics, x - 2, y, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, rgba[0], rgba[1], rgba[2], rgba[3], 1.0f);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private float getYawFromVec3(Vec3 vec, Player player) {
        double dx = vec.f_82479_;
        double dz = vec.f_82481_;
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI - 90.0 - (double)player.f_19857_) + 90.0f;
    }

    private boolean drawArrow(GuiGraphics graphics, QuestMarker marker, double x, double y, float z, float[] rgba) {
        Vec3 markerPos = this.getVecForMarker(marker);
        if (markerPos != null) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack matrix = graphics.m_280168_();
            matrix.m_85836_();
            Vec3 v1 = new Vec3(mc.f_91074_.m_20185_() + 0.5, mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_() + 0.5);
            Vec3 v2 = new Vec3(markerPos.f_82479_, markerPos.f_82480_, markerPos.f_82481_);
            Vec3 v3 = v2.m_82546_(v1).m_82541_();
            v3 = new Vec3(-v3.f_82479_, v3.f_82480_, -v3.f_82481_);
            int arrWidth = 18;
            int arrHeight = 18;
            matrix.m_85837_(x + (double)((float)arrWidth / 2.0f), y + (double)((float)arrHeight / 2.0f), 0.0);
            matrix.m_252781_(QuaternionHelper.fromEuler(this.getYawFromVec3(v3, (Player)mc.f_91074_) + 180.0f, 0.0f, 0.0f, 1.0f));
            ScreenHelper.drawImage(Resources.arrow, graphics, (float)(-arrWidth) / 2.0f, (float)(-arrHeight) / 2.0f, 18.0f, 18.0f, rgba[0], rgba[1], rgba[2], rgba[3], z);
            matrix.m_85849_();
            return true;
        }
        return false;
    }

    private Vec3 getVecForMarker(QuestMarker marker) {
        Minecraft mc = Minecraft.m_91087_();
        double x = marker.x;
        double y = marker.y;
        double z = marker.z;
        boolean found = false;
        if (marker.uuid != null) {
            for (Entity entity : mc.f_91073_.m_104735_()) {
                if (entity == null || !entity.m_20148_().equals(marker.uuid)) continue;
                x = (double)((float)(entity.f_19854_ + (entity.m_20185_() - entity.f_19854_) * (double)mc.m_91296_())) + 0.5;
                y = (double)((float)(entity.f_19855_ + (entity.m_20186_() - entity.f_19855_) * (double)mc.m_91296_()) + entity.m_20192_()) + 0.8;
                z = (double)((float)(entity.f_19856_ + (entity.m_20189_() - entity.f_19856_) * (double)mc.m_91296_())) + 0.5;
                found = true;
                break;
            }
        } else {
            found = true;
        }
        if (!found) {
            return null;
        }
        return new Vec3(x, y, z);
    }
}

