/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.rendering.QuestResources;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuestMarkerRenderer {
    @SubscribeEvent
    public void onRenderEvent(RenderLivingEvent.Post event) {
        PoseStack matrix = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        for (QuestProgressClient progress : QuestDataClient.getInstance().getQuests()) {
            for (QuestMarker marker : progress.getMarkers()) {
                if (!Objects.equals(marker.dim, mc.f_91073_.m_46472_()) || marker.uuid == null || !event.getEntity().m_20148_().equals(marker.uuid)) continue;
                LivingEntity entity = event.getEntity();
                double x = (float)(entity.f_19854_ + (entity.m_20185_() - entity.f_19854_) * (double)mc.m_91296_());
                double y = (double)((float)(entity.f_19855_ + (entity.m_20186_() - entity.f_19855_) * (double)mc.m_91296_()) + entity.m_20192_()) + 0.8;
                double z = (float)(entity.f_19856_ + (entity.m_20189_() - entity.f_19856_) * (double)mc.m_91296_());
                this.renderMarker(matrix, buffer, progress, marker, mc, x, y, z);
            }
        }
    }

    @SubscribeEvent
    public void onPostRender(RenderLevelStageEvent event) {
        PoseStack matrix = event.getPoseStack();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        for (QuestProgressClient progress : QuestDataClient.getInstance().getQuests()) {
            for (QuestMarker marker : progress.getMarkers()) {
                if (!Objects.equals(marker.dim, mc.f_91073_.m_46472_()) || marker.uuid != null) continue;
                this.renderMarker(matrix, (MultiBufferSource)event.getLevelRenderer().f_109464_.m_110104_(), progress, marker, mc, marker.x, marker.y, marker.z);
            }
        }
    }

    private void renderMarker(PoseStack matrix, MultiBufferSource buffer, QuestProgressClient progress, QuestMarker marker, Minecraft mc, double x, double y, double z) {
        matrix.m_85836_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        QuestColor qc = marker.getColor(mc.f_91073_.m_46468_());
        matrix.m_85837_(0.0, 2.5, 0.0);
        matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
        float angle = (float)(Math.atan2(z - view.f_82481_, x - view.f_82479_) * 180.0 / Math.PI) + 90.0f;
        matrix.m_252781_(QuaternionHelper.fromEuler(angle, 0.0f, 0.0f, 1.0f));
        matrix.m_85841_(0.075f, 0.075f, 0.075f);
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(QuestResources.getMarkerTexture(progress, marker)));
        QuestResources.getMarkerModel(marker).render(matrix, vertices, 0xF000F0, OverlayTexture.f_118083_, qc.floatR(), qc.floatG(), qc.floatB(), 1.0f);
        matrix.m_85849_();
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        QuestDataClient.getInstance().clear();
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        QuestDataClient.getInstance().clear();
    }
}

