/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor.ui;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;

public class TextField
extends AbstractWidget {
    public final Font font;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    private String text = "";
    private int maxStringLength = 32;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private boolean isEnabled = true;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private boolean visible = true;
    private static final String __OBFID = "CL_00000670";
    int backgroundColour;
    int borderColour;

    public TextField(Font fontRenderer, int xPos, int yPos, int width, int height, int backgroundColour, int borderColour) {
        super(xPos, yPos, width, height, (Component)Component.m_237119_());
        this.font = fontRenderer;
        this.xPosition = xPos;
        this.yPosition = yPos;
        this.width = width;
        this.height = height;
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setText(String p_146180_1_) {
        this.text = p_146180_1_.length() > this.maxStringLength ? p_146180_1_.substring(0, this.maxStringLength) : p_146180_1_;
        this.setCursorPositionEnd();
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void writeText(String p_146191_1_) {
        int l;
        Object s1 = "";
        String s2 = SharedConstants.m_136190_((String)p_146191_1_);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - this.selectionEnd);
        boolean flag = false;
        if (this.text.length() > 0) {
            s1 = (String)s1 + this.text.substring(0, i);
        }
        if (k < s2.length()) {
            s1 = (String)s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = (String)s1 + s2;
            l = s2.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s1 = (String)s1 + this.text.substring(j);
        }
        this.text = s1;
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteWords(int p_146177_1_) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(p_146177_1_) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int p_146175_1_) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = p_146175_1_ < 0;
                int j = flag ? this.cursorPosition + p_146175_1_ : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + p_146175_1_;
                Object s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = (String)s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(p_146175_1_);
                }
            }
        }
    }

    public int getNthWordFromCursor(int p_146187_1_) {
        return this.getNthWordFromPos(p_146187_1_, this.getCursorPosition());
    }

    public int getNthWordFromPos(int p_146183_1_, int p_146183_2_) {
        return this.getWordPosition(p_146183_1_, this.getCursorPosition(), true);
    }

    public int getWordPosition(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int k = p_146197_2_;
        boolean flag1 = p_146197_1_ < 0;
        int l = Math.abs(p_146197_1_);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (p_146197_3_ && k > 0 && this.text.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.text.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.text.length();
            if ((k = this.text.indexOf(32, k)) == -1) {
                k = j1;
                continue;
            }
            while (p_146197_3_ && k < j1 && this.text.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void moveCursorBy(int p_146182_1_) {
        this.setCursorPosition(this.selectionEnd + p_146182_1_);
    }

    public void setCursorPosition(int p_146190_1_) {
        this.cursorPosition = p_146190_1_;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public boolean m_5534_(char p_146201_1_, int p_146201_2_) {
        if (!this.isFocused) {
            return false;
        }
        switch (p_146201_1_) {
            case '\u0001': {
                this.setCursorPositionEnd();
                this.setSelectionPos(0);
                return true;
            }
            case '\u0003': {
                Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
                return true;
            }
            case '\u0016': {
                if (this.isEnabled) {
                    this.writeText(Minecraft.m_91087_().f_91068_.m_90876_());
                }
                return true;
            }
            case '\u0018': {
                Minecraft.m_91087_().f_91068_.m_90911_(this.getSelectedText());
                if (this.isEnabled) {
                    this.writeText("");
                }
                return true;
            }
        }
        switch (p_146201_2_) {
            case 14: {
                if (Screen.m_96637_()) {
                    if (this.isEnabled) {
                        this.deleteWords(-1);
                    }
                } else if (this.isEnabled) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (Screen.m_96638_()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (Screen.m_96638_()) {
                    if (Screen.m_96637_()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                    }
                } else if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (Screen.m_96638_()) {
                    if (Screen.m_96637_()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                    } else {
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                    }
                } else if (Screen.m_96637_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (Screen.m_96638_()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (Screen.m_96637_()) {
                    if (this.isEnabled) {
                        this.deleteWords(1);
                    }
                } else if (this.isEnabled) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (SharedConstants.m_136188_((char)p_146201_1_)) {
            if (this.isEnabled) {
                this.writeText(Character.toString(p_146201_1_));
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double p_146192_1_, double p_146192_2_, int p_146192_3_) {
        boolean flag;
        boolean bl = flag = p_146192_1_ >= (double)this.xPosition && p_146192_1_ < (double)(this.xPosition + this.width) && p_146192_2_ >= (double)this.yPosition && p_146192_2_ < (double)(this.yPosition + this.height);
        if (this.canLoseFocus) {
            this.m_93692_(flag);
        }
        if (this.isFocused && p_146192_3_ == 0) {
            int l = (int)(p_146192_1_ - (double)this.xPosition);
            if (this.enableBackgroundDrawing) {
                l -= 4;
            }
            String s = this.font.m_92834_(this.text.substring(this.lineScrollOffset), this.m_5711_());
            this.setCursorPosition(this.font.m_92834_(s, l).length() + this.lineScrollOffset);
        }
        return flag;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            if (this.getEnableBackgroundDrawing()) {
                graphics.m_280509_(this.xPosition - 1, this.yPosition - 1, this.xPosition + this.width + 1, this.yPosition + this.height + 1, this.borderColour);
                graphics.m_280509_(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, this.backgroundColour);
            }
            int i = this.isEnabled ? this.enabledColor : this.disabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.font.m_92834_(this.text.substring(this.lineScrollOffset), this.m_5711_());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
            int l = this.enableBackgroundDrawing ? this.xPosition + 4 : this.xPosition;
            int i1 = this.enableBackgroundDrawing ? this.yPosition + (this.height - 8) / 2 : this.yPosition;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (s.length() > 0) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = graphics.m_280488_(this.font, s1, l, i1, i);
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (s.length() > 0 && flag && j < s.length()) {
                graphics.m_280488_(this.font, s.substring(j), j1, i1, i);
            }
            if (flag1) {
                if (flag2) {
                    Objects.requireNonNull(this.font);
                    graphics.m_280509_(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    graphics.m_280488_(this.font, "_", k1, i1, i);
                }
            }
            if (k != j) {
                int l1 = l + this.font.m_92895_(s.substring(0, k));
                Objects.requireNonNull(this.font);
                this.drawCursorVertical(graphics, k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void drawCursorVertical(GuiGraphics graphics, int p_146188_1_, int p_146188_2_, int p_146188_3_, int p_146188_4_) {
        int i1;
        if (p_146188_1_ < p_146188_3_) {
            i1 = p_146188_1_;
            p_146188_1_ = p_146188_3_;
            p_146188_3_ = i1;
        }
        if (p_146188_2_ < p_146188_4_) {
            i1 = p_146188_2_;
            p_146188_2_ = p_146188_4_;
            p_146188_4_ = i1;
        }
        if (p_146188_3_ > this.xPosition + this.width) {
            p_146188_3_ = this.xPosition + this.width;
        }
        if (p_146188_1_ > this.xPosition + this.width) {
            p_146188_1_ = this.xPosition + this.width;
        }
        graphics.m_280246_(0.0f, 0.0f, 255.0f, 255.0f);
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        buffer.m_7421_((float)p_146188_1_, (float)p_146188_4_);
        buffer.m_7421_((float)p_146188_3_, (float)p_146188_4_);
        buffer.m_7421_((float)p_146188_3_, (float)p_146188_2_);
        buffer.m_7421_((float)p_146188_1_, (float)p_146188_2_);
        graphics.m_280091_().m_109911_();
    }

    public void setMaxStringLength(int p_146203_1_) {
        this.maxStringLength = p_146203_1_;
        if (this.text.length() > p_146203_1_) {
            this.text = this.text.substring(0, p_146203_1_);
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean p_146185_1_) {
        this.enableBackgroundDrawing = p_146185_1_;
    }

    public void setTextColor(int p_146193_1_) {
        this.enabledColor = p_146193_1_;
    }

    public void setBorderColour(int color) {
        this.borderColour = color;
    }

    public void setDisabledTextColour(int p_146204_1_) {
        this.disabledColor = p_146204_1_;
    }

    public void m_93692_(boolean p_146195_1_) {
        if (p_146195_1_ && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = p_146195_1_;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public boolean m_93696_() {
        return this.isFocused;
    }

    public void setEnabled(boolean p_146184_1_) {
        this.isEnabled = p_146184_1_;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int m_5711_() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int p_146199_1_) {
        int j = this.text.length();
        if (p_146199_1_ > j) {
            p_146199_1_ = j;
        }
        if (p_146199_1_ < 0) {
            p_146199_1_ = 0;
        }
        this.selectionEnd = p_146199_1_;
        if (this.font != null) {
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
            int k = this.m_5711_();
            String s = this.font.m_92834_(this.text.substring(this.lineScrollOffset), k);
            int l = s.length() + this.lineScrollOffset;
            if (p_146199_1_ == this.lineScrollOffset) {
                this.lineScrollOffset -= this.font.m_92834_(this.text, k).length();
            }
            if (p_146199_1_ > l) {
                this.lineScrollOffset += p_146199_1_ - l;
            } else if (p_146199_1_ <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - p_146199_1_;
            }
            if (this.lineScrollOffset < 0) {
                this.lineScrollOffset = 0;
            }
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
        }
    }

    public void setCanLoseFocus(boolean p_146205_1_) {
        this.canLoseFocus = p_146205_1_;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean p_146189_1_) {
        this.visible = p_146189_1_;
    }
}

