/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor.ui;

import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestStringsScreen;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ListQuestLang
extends AbstractWidget {
    public static final int X_OFFSET = 4;
    public static final int Y_OFFSET = 2;
    private final Font fRend;
    public int xPos = 0;
    public int yPos = 0;
    public int width = 12;
    public int height = 12;
    public boolean drawBackground = true;
    public boolean drawBorder = true;
    public boolean isEnabled = true;
    public boolean isFocused = false;
    public int borderColor = -6250336;
    public int backgroundColor = 0xF2F2F2;
    public int selectedLineColor = 0x4D4D4D;
    public int textColor = Color.BLACK.getRGB();
    public int selectedTextColor = Color.WHITE.getRGB();
    public int displayLines = 0;
    public int lineHeight = 10;
    public List<String> lines = new LinkedList<String>();
    public int startLine = 0;
    public Integer selected = null;
    public boolean highlightSelectedLine = true;

    public ListQuestLang(Font fontRenderer, int x, int y, int w, int lines) {
        super(x, y, w, w, (Component)Component.m_237119_());
        this.fRend = fontRenderer;
        this.xPos = x;
        this.yPos = y;
        this.displayLines = lines;
        Objects.requireNonNull(fontRenderer);
        this.lineHeight = 9 + 6;
        this.width = w;
        this.height = this.displayLines * this.lineHeight + 2;
    }

    public void drawBackground(GuiGraphics matrix) {
        int bottomMarker = this.lineHeight * 9 - 1;
        matrix.m_280509_(this.xPos, this.yPos + 1, this.xPos + this.width + 6, this.yPos + 3 + bottomMarker, -10066330);
        if (this.lines.size() > 9 && this.displayLines == 9) {
            float barMult = 9.0f / ((float)this.lines.size() - 8.0f);
            float barHeight = (float)this.lineHeight * barMult;
            float barPos = barHeight * (float)this.startLine;
            matrix.m_280509_(this.xPos + this.width, this.yPos + 3 + (int)barPos, this.xPos + this.width + 6, this.yPos + 3 + (int)barPos + (int)barHeight, -6710887);
            matrix.m_280509_(this.xPos + this.width, this.yPos + 1, this.xPos + this.width + 6, this.yPos + 3, -7829368);
            matrix.m_280509_(this.xPos + this.width, this.yPos + 1 + bottomMarker, this.xPos + this.width + 6, this.yPos + 3 + bottomMarker, -7829368);
        }
    }

    public void drawText(GuiGraphics matrix) {
        for (int i = this.startLine; i < this.startLine + this.displayLines; ++i) {
            String line;
            if (i >= this.lines.size() || i < 0 || (line = this.lines.get(i)) == null) continue;
            double wf = 125.0;
            line = QuestStringsScreen.prettifyLangKey(line);
            if (this.selected != null && this.selected == i && this.highlightSelectedLine) {
                matrix.m_280509_(this.xPos, this.yPos + 1 + this.lineHeight * (i - this.startLine), this.xPos + this.width, this.yPos + this.lineHeight * (1 + i - this.startLine) + this.lineHeight / 4 - 1, -7829368);
                ScreenHelper.drawSquashedString(matrix, this.fRend, line, false, (float)wf, (float)(this.xPos + 4 + 12), (float)(this.yPos + 2 + this.lineHeight * (i - this.startLine) + this.lineHeight / 4), this.selectedTextColor, true);
                continue;
            }
            ScreenHelper.drawSquashedString(matrix, this.fRend, line, false, (float)wf, (float)(this.xPos + 4 + 12), (float)(this.yPos + 2 + this.lineHeight * (i - this.startLine) + this.lineHeight / 4), this.selectedTextColor, false);
        }
    }

    public String mouseClicked(double mouseX, double mouseY, int mouseButton, int offsetY) {
        int theLine;
        int index;
        if (mouseX > (double)this.xPos && mouseX < (double)(this.xPos + this.width) && mouseY > (double)this.yPos && mouseY < (double)(this.yPos + this.height) && (index = (theLine = (int)(((mouseY += 8.0) - (double)offsetY) / (double)this.lineHeight)) + this.startLine) < this.lines.size() && index >= 0) {
            return this.lines.get(index);
        }
        return null;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    protected void m_87963_(GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    public void m_93692_(boolean focus) {
        this.isFocused = focus;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public void select(int i) {
        this.selected = i;
    }

    public void scrollUp() {
        ++this.startLine;
        if (this.startLine > this.lines.size() - this.displayLines) {
            this.startLine = this.lines.size() - this.displayLines;
        }
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }

    public void scrollDown() {
        --this.startLine;
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }
}

