/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.awt.Color;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ListQuestEditor
extends AbstractWidget {
    private static final ResourceLocation circle = ResourceLocationHelper.of("pixelmon", "textures/gui/quests/circle.png");
    private static final ResourceLocation exclamation_mark = ResourceLocationHelper.of("pixelmon", "textures/gui/quests/exclamation_mark.png");
    private static final ResourceLocation question_mark = ResourceLocationHelper.of("pixelmon", "textures/gui/quests/question_mark.png");
    public static final int X_OFFSET = 4;
    public static final int Y_OFFSET = 2;
    private final Font fRend;
    public int xPos = 0;
    public int yPos = 0;
    public int width = 12;
    public int height = 12;
    public boolean drawBackground = true;
    public boolean drawBorder = true;
    public boolean isEnabled = true;
    public boolean isFocused = false;
    public int borderColor = -6250336;
    public int backgroundColor = 0xF2F2F2;
    public int selectedLineColor = 0x4D4D4D;
    public int textColor = Color.BLACK.getRGB();
    public int selectedTextColor = Color.WHITE.getRGB();
    public int displayLines = 0;
    public int lineHeight = 10;
    public List<Quest> lines = new LinkedList<Quest>();
    public int startLine = 0;
    public Integer selectedQuest = null;
    public boolean highlightSelectedLine = true;

    public ListQuestEditor(Font fontRenderer, int x, int y, int w, int lines) {
        super(x, y, w, w, (Component)Component.m_237119_());
        this.fRend = fontRenderer;
        this.xPos = x;
        this.yPos = y;
        this.displayLines = lines;
        Objects.requireNonNull(fontRenderer);
        this.lineHeight = 9 + 6;
        this.width = w;
        this.height = this.displayLines * this.lineHeight + 2;
    }

    public boolean sort(String search) {
        boolean changedSize = false;
        if (!search.isEmpty()) {
            changedSize = this.lines.removeIf(quest -> !quest.getPrintableName().toLowerCase(Locale.ROOT).startsWith(search.toLowerCase(Locale.ROOT)));
        }
        this.lines.sort(Comparator.comparing(Quest::getIdentityName));
        return changedSize;
    }

    public void drawBackground(GuiGraphics matrix) {
        if (this.lines.size() > 9 && this.displayLines == 9) {
            int bottomMarker = this.lineHeight * 9 - 1;
            float barMult = 9.0f / ((float)this.lines.size() - 8.0f);
            float barHeight = (float)this.lineHeight * barMult;
            float barPos = barHeight * (float)this.startLine;
            matrix.m_280509_(this.xPos + this.width + 2, this.yPos + 3 + (int)barPos, this.xPos + this.width + 6, this.yPos + 3 + (int)barPos + (int)barHeight, -6710887);
            matrix.m_280509_(this.xPos + this.width + 2, this.yPos + 1, this.xPos + this.width + 6, this.yPos + 3, -7829368);
            matrix.m_280509_(this.xPos + this.width + 2, this.yPos + 1 + bottomMarker, this.xPos + this.width + 6, this.yPos + 3 + bottomMarker, -7829368);
        }
    }

    public void drawText(GuiGraphics matrix) {
        Minecraft mc = Minecraft.m_91087_();
        for (int i = this.startLine; i < this.startLine + this.displayLines; ++i) {
            Quest quest;
            if (i >= this.lines.size() || i < 0 || (quest = this.lines.get(i)) == null) continue;
            double wf = 85.0;
            if (this.selectedQuest != null && this.selectedQuest == i && this.highlightSelectedLine) {
                matrix.m_280509_(this.xPos, this.yPos + 1 + this.lineHeight * (i - this.startLine), this.xPos + this.width, this.yPos + this.lineHeight * (1 + i - this.startLine) + this.lineHeight / 4 - 1, -7829368);
                ScreenHelper.drawSquashedString(matrix, this.fRend, quest.getPrintableName(), false, (float)wf, (float)(this.xPos + 4 + 12), (float)(this.yPos + 2 + this.lineHeight * (i - this.startLine) + this.lineHeight / 4), this.selectedTextColor, true);
            } else {
                ScreenHelper.drawSquashedString(matrix, this.fRend, quest.getPrintableName(), false, (float)wf, (float)(this.xPos + 4 + 12), (float)(this.yPos + 2 + this.lineHeight * (i - this.startLine) + this.lineHeight / 4), this.selectedTextColor, false);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            if (quest.getColor() == null) {
                matrix.m_280246_(0.8509804f, 0.8509804f, 0.8509804f, 1.0f);
            } else {
                QuestColor color = quest.getColor();
                matrix.m_280246_(color.floatR(), color.floatG(), color.floatB(), 1.0f);
            }
            matrix.m_280163_(quest.getStages().get(quest.getStages().size() - 1).getStage() == quest.getActiveStage() ? question_mark : exclamation_mark, this.xPos + 1, this.yPos + 1 + this.lineHeight * (i - this.startLine) + 1, 0.0f, 0.0f, 14, 14, 14, 14);
        }
    }

    public Quest mouseClicked(double mouseX, double mouseY, int mouseButton, int offsetY) {
        int theLine;
        int index;
        if (mouseX > (double)this.xPos && mouseX < (double)(this.xPos + this.width) && mouseY > (double)this.yPos && mouseY < (double)(this.yPos + this.height) && (index = (theLine = (int)(((mouseY += 8.0) - (double)offsetY) / (double)this.lineHeight)) + this.startLine) < this.lines.size() && index >= 0) {
            return this.lines.get(index);
        }
        return null;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    protected void m_87963_(GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    public void m_93692_(boolean focus) {
        this.isFocused = focus;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void addLine(Quest quest) {
        this.lines.add(quest);
    }

    public void selectQuest(int i) {
        this.selectedQuest = i;
    }

    public void scrollUp() {
        ++this.startLine;
        if (this.startLine > this.lines.size() - this.displayLines) {
            this.startLine = this.lines.size() - this.displayLines;
        }
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }

    public void scrollDown() {
        --this.startLine;
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }
}

