/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestOverviewScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.ListQuestLang;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.SimpleButton;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.TextField;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class QuestStringsScreen
extends Screen {
    private List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private ListQuestLang list;
    private TextField field;
    private String selection = null;
    private boolean reload = false;
    int prevWidth = -1;
    int prevHeight = -1;

    protected QuestStringsScreen() {
        super((Component)Component.m_237119_());
    }

    public void m_7856_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        float titleBorder = 5.5f;
        int listW = 150;
        this.list = new ListQuestLang(this.f_96541_.f_91062_, x + dispWidth / 2 - listW / 2 - 4, y + 15, listW, 9);
        this.list.m_93692_(true);
        ArrayList<String> keys = new ArrayList<String>(QuestEditorState.get().getSelectedQuest().getUnlocalizedStringMap().keySet());
        Collections.sort(keys);
        for (String key : keys) {
            this.list.addLine(key);
        }
        this.field = new TextField(this.f_96541_.f_91062_, x, y + dispHeight - 25, dispWidth - 6, 9, -6908266, -7895161);
        this.field.setMaxStringLength(Integer.MAX_VALUE);
        this.field.setTextColor(-1);
        if (this.selection != null) {
            this.field.setText(QuestEditorState.get().getSelectedQuest().getUnlocalizedStringMap().get(this.selection));
        }
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        this.buttons.add(new SimpleButton(0, x + 4, y + 6, 12, Resources.back, 2, 2, -12407307));
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float f) {
        int qlh;
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        Quest quest = QuestEditorState.get().getSelectedQuest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        super.m_88315_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        this.list.height = qlh = 132;
        this.list.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        matrix.m_280163_(Resources.backgroundTexture, x - gap, y, 0.0f, 0.0f, dispWidth, dispHeight, dispWidth, dispHeight);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableBlend();
        for (SimpleButton button : this.buttons) {
            button.renderWidget(matrix);
        }
        this.list.drawBackground(matrix);
        this.list.drawText(matrix);
        this.field.m_87963_(matrix, mouseX, mouseY, this.f_96541_.m_91296_());
        ScreenHelper.drawCenteredString(matrix, this.selection == null ? "None Selected" : QuestStringsScreen.prettifyLangKey(this.selection), (float)x + (float)dispWidth / 2.0f, (float)(y + dispHeight) - 37.5f, 0xFFFFFF);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        String clickedOn;
        int xOffset = 20;
        int yOffset = 20;
        int id = -1;
        for (SimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            this.f_96541_.m_91152_((Screen)new QuestOverviewScreen());
        }
        if ((clickedOn = this.list.mouseClicked(mouseX, mouseY, 0, this.list.yPos + 8)) != null) {
            int lineindex = this.list.lines.indexOf(clickedOn);
            this.list.select(lineindex);
            if (lineindex >= 0 && lineindex < this.list.lines.size()) {
                this.selection = this.list.lines.get(lineindex);
                this.field.setText(QuestEditorState.get().getSelectedQuest().getUnlocalizedStringMap().get(this.selection));
            } else {
                this.selection = null;
            }
        }
        this.field.m_6375_(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean m_7933_(int c, int i, int modifier) {
        super.m_7933_(c, i, modifier);
        if (this.field.m_93696_() && this.field.m_5534_(Character.forDigit(c, modifier), i) && this.selection != null) {
            QuestEditorState.get().getSelectedQuest().putUnlocalizedString(this.selection, this.field.getText());
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY == 120.0) {
            if (this.list.isFocused) {
                this.list.scrollDown();
            }
        } else if (deltaY == -120.0 && this.list.isFocused) {
            this.list.scrollUp();
        }
        return true;
    }

    public void m_86600_() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.f_96541_.m_91152_((Screen)new QuestEditorScreen());
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.f_96543_ != this.prevWidth || this.f_96544_ != this.prevHeight)) {
            this.m_7856_();
        }
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.reload = false;
        }
        this.prevWidth = this.f_96543_;
        this.prevHeight = this.f_96544_;
    }

    public static String prettifyLangKey(String line) {
        boolean changed = false;
        try {
            if (((String)line).startsWith("desc-")) {
                String stage = ((String)line).replace("desc-", "");
                line = stage.equalsIgnoreCase("X") ? "Quest Complete Description" : "Stage " + stage + " Description";
                changed = true;
            } else if (((String)line).equalsIgnoreCase("name")) {
                line = "Quest Name";
                changed = true;
            } else if (((String)line).startsWith("stage-")) {
                String[] split = ((String)line).split("-");
                line = "Stage " + split[1] + " Objective " + (Integer.parseInt(split[2]) + 1);
                changed = true;
            } else if (((String)line).matches("[A-z]+[0-9]+-[A-z]+[0-9]+-[A-z]+[0-9]+")) {
                String[] split = ((String)line).split("-");
                line = "Stage " + split[0].substring(1) + " Objective " + (Integer.parseInt(split[1].substring(1)) + 1) + " Element " + (Integer.parseInt(split[2].substring(1)) + 1);
                changed = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!changed) {
            line = "String Key " + (String)line;
        }
        return line;
    }
}

