/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownManager;
import com.pixelmonmod.pixelmon.quests.actions.ExecutorMode;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestOverviewScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.SimpleButton;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.math.NumberUtils;

public class QuestStageScreen
extends Screen {
    private List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private Stage stage;
    private CopyOnWriteArrayList<QuestElement> objectives;
    private CopyOnWriteArrayList<QuestElement> actions;
    private QuestElement selection = null;
    private HashSet<Integer> actionObjectives = new HashSet();
    private ExecutorMode actionMode = ExecutorMode.AND;
    private ArrayList<AbstractWidget> selectionElements = new ArrayList();
    private DropDown<QuestElement> dropDown;
    private final DropDownManager dropDownManager = new DropDownManager();
    private MouseState mouseState = MouseState.HOVER;
    private boolean reload = false;
    int prevWidth = -1;
    int prevHeight = -1;

    public QuestStageScreen(Stage stage) {
        super((Component)Component.m_237119_());
        this.stage = stage;
        this.objectives = new CopyOnWriteArrayList<QuestElement>(QuestEditorState.get().getObjectivesForStage(stage));
        this.actions = new CopyOnWriteArrayList<QuestElement>(QuestEditorState.get().getActionsForStage(stage));
        this.dropDownManager.clearDropDowns();
    }

    public void m_7856_() {
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int id = 0;
        int buttonS = 14;
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 0, y + 6, 12, Resources.back, 2, 2, -12407307));
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 1, y + 6, 12, Resources.save, 2, 2, -14300093));
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 2, y + 6, 12, Resources.discard, 2, 2, -2210481));
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float f) {
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        super.m_88315_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        ScreenHelper.bindTexture(Resources.backgroundTexture);
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        matrix.m_280163_(Resources.backgroundTexture, x - gap, y, 0.0f, 0.0f, dispWidth / 2, dispHeight, (int)((float)dispWidth / 2.0f), dispHeight);
        matrix.m_280163_(Resources.backgroundTexture, x + dispWidth / 2 + gap + 1, y, 0.0f, 0.0f, dispWidth / 2, dispHeight, (int)((float)dispWidth / 2.0f), dispHeight);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        this.drawElements(matrix, x, y, mouseX, mouseY);
        RenderSystem.disableBlend();
        for (SimpleButton button : this.buttons) {
            button.renderWidget(matrix);
        }
        if (this.selection != null) {
            this.selection.draw(matrix, this.f_96541_, x, y, dispWidth, dispHeight);
        }
        this.dropDownManager.drawDropDowns(matrix, 0.0f, mouseX, mouseY);
        if (this.mouseState == MouseState.PRESS) {
            matrix.m_280163_(Resources.backgroundTexture, x + 104, y + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private void drawElements(GuiGraphics matrix, int x, int y, int mouseX, int mouseY) {
        boolean showActionOptions;
        boolean mouseDown = Minecraft.m_91087_().f_91067_.m_91560_();
        if (mouseDown) {
            if (this.mouseState == MouseState.HOVER) {
                this.mouseState = MouseState.PRESS;
            } else if (this.mouseState == MouseState.PRESS) {
                this.mouseState = MouseState.DRAG;
            }
        } else if (this.mouseState == MouseState.PRESS || this.mouseState == MouseState.DRAG) {
            this.mouseState = MouseState.RELEASE;
        } else if (this.mouseState == MouseState.RELEASE) {
            this.mouseState = MouseState.HOVER;
        }
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int left = x + 4;
        int top = y + 24;
        int right = x + dispWidth / 2 - 10;
        int size = 13;
        boolean bl = showActionOptions = this.selection != null && this.selection.getType() == QuestElementType.ACTION;
        if (showActionOptions) {
            ScreenHelper.drawCenteredString(matrix, ChatFormatting.BOLD + this.actionMode.name(), (float)right - 6.0f, (float)(top - 8), 0);
        }
        int i = 0;
        for (QuestElement element : this.objectives) {
            this.drawElement(matrix, element, x, y, dispWidth, dispHeight, i++, size, left, right, top, mouseX, mouseY, -17664);
        }
        for (QuestElement element : this.actions) {
            this.drawElement(matrix, element, x, y, dispWidth, dispHeight, i++, size, left, right, top, mouseX, mouseY, -5479425);
        }
        int addY = top + (size - 1) * i + 5;
        matrix.m_280509_(left + 20, addY, left + 40, addY + 10, -17664);
        ScreenHelper.drawCenteredString(matrix, "+", (float)left + 30.5f, (float)addY + 1.75f, -16777216);
        matrix.m_280509_(right - 40, addY, right - 20, addY + 10, -5479425);
        ScreenHelper.drawCenteredString(matrix, "+", (float)(right - 40) + 10.5f, (float)addY + 1.75f, -16777216);
        if (this.mouseState == MouseState.PRESS) {
            if (showActionOptions && mouseX >= right - 12 && mouseX <= right && mouseY >= top - 8 && mouseY <= top - 2) {
                this.actionMode = this.actionMode == ExecutorMode.AND ? ExecutorMode.OR : ExecutorMode.AND;
            } else if (mouseY >= addY && mouseY <= addY + 10) {
                if (mouseX >= left + 20 && mouseX <= left + 40) {
                    this.objectives.add(QuestEditorState.get().getObjectives().get(0).copy());
                } else if (mouseX >= right - 40 && mouseX <= right - 20) {
                    this.actions.add(QuestEditorState.get().getActions().get(0).copy());
                }
            }
        }
        QuestColor color = QuestEditorState.get().getSelectedQuest().getColor();
        matrix.m_280246_(color.floatR(), color.floatG(), color.floatB(), 1.0f);
        matrix.m_280163_(this.stage.getIcon().getResource(), x + 60, y + 4, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void drawElement(GuiGraphics matrix, QuestElement element, int x, int y, int w, int h, int i, int size, int left, int right, int top, int mouseX, int mouseY, int color) {
        boolean selected;
        int offset = (size - 1) * i;
        boolean bl = selected = this.selection == element;
        if (selected) {
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
        }
        boolean showActionOptions = this.selection != null && this.selection.getType() == QuestElementType.ACTION && element.getType() == QuestElementType.OBJECTIVE;
        int nudge = 0;
        if (showActionOptions) {
            nudge = 12;
        }
        int x1 = left;
        int x2 = right - nudge;
        int y1 = top + offset;
        int y2 = top + size + offset;
        matrix.m_280509_(x1, y1, x2, y2, selected ? -1 : -16777216);
        matrix.m_280509_(x1 + 1, y1 + 1, x2 - 1, y2 - 1, color);
        ScreenHelper.drawSquashedString(matrix, this.f_96547_, I18n.m_118936_((String)element.getName()) ? I18n.m_118938_((String)element.getName(), (Object[])new Object[0]) : element.getIdentifier(), false, showActionOptions ? 84.0f : 95.0f, (float)(x1 + 3), (float)(y1 + size / 2 - 3), -16777216, false);
        matrix.m_280509_(x2 - 11, y1 + 2, x2 - 2, y1 + 11, -2210481);
        matrix.m_280488_(this.f_96547_, "-", x2 - 9, y1 + 3, -1);
        if (showActionOptions) {
            matrix.m_280509_(right - 11, y1 + 2, right - 2, y1 + 3, -16777216);
            matrix.m_280509_(right - 11, y1 + 10, right - 2, y1 + 11, -16777216);
            matrix.m_280509_(right - 11, y1 + 2, right - 10, y1 + 11, -16777216);
            matrix.m_280509_(right - 3, y1 + 2, right - 2, y1 + 11, -16777216);
            if (this.actionObjectives.contains(i)) {
                matrix.m_280509_(right - 10, y1 + 3, right - 3, y1 + 10, -5479425);
            }
        }
        if (this.mouseState == MouseState.PRESS) {
            if (showActionOptions && mouseX >= right - 11 && mouseY >= y1 + 2 && mouseX <= right - 2 && mouseY <= y1 + 11) {
                if (!this.actionObjectives.remove(i)) {
                    this.actionObjectives.add(i);
                }
            } else if (mouseX >= x2 - 11 && mouseY >= y1 + 2 && mouseX <= x2 - 2 && mouseY <= y1 + 11) {
                this.deleteElement(element);
            } else if (mouseX >= x1 && mouseY >= y1 && mouseX <= x2 && mouseY <= y2) {
                this.selectElement(element, x, y, w, h);
            }
        }
        if (selected) {
            matrix.m_280168_().m_85849_();
        }
    }

    private void writeExtraString(QuestElement element) {
        if (element != null && element.getType() == QuestElementType.ACTION) {
            StringBuilder extra = new StringBuilder(this.actionMode == ExecutorMode.AND ? "+" : "");
            boolean first = true;
            for (int i : this.actionObjectives) {
                if (!first) {
                    extra.append(",");
                }
                extra.append(i);
                first = false;
            }
            String result = extra.toString();
            if (result.isEmpty() || result.equalsIgnoreCase("+")) {
                element.setExtra("0");
            } else {
                element.setExtra(result);
            }
        }
    }

    private void selectElement(QuestElement element, int x, int y, int w, int h) {
        this.writeExtraString(this.selection);
        this.selection = element;
        if (this.selection.getType() == QuestElementType.ACTION) {
            String objArgs = this.selection.getExtra();
            ExecutorMode executorMode = this.actionMode = objArgs.startsWith("+") ? ExecutorMode.AND : ExecutorMode.OR;
            if (this.actionMode == ExecutorMode.AND) {
                objArgs = objArgs.substring(1);
            }
            String[] split = objArgs.split(",");
            this.actionObjectives.clear();
            for (String arg : split) {
                if (!NumberUtils.isParsable((String)arg)) continue;
                int i = Integer.parseInt(arg);
                if (this.objectives.size() <= i) continue;
                this.actionObjectives.add(i);
            }
        }
        this.selection.initialize(this.f_96541_, x, y, w, h);
        this.setDropDowns(x, y, w, h);
    }

    private void setDropDowns(int x, int y, int w, int h) {
        int dropDownX = x + w / 2 + 6;
        int dropDownY = y + 2;
        int dropDownW = 111;
        int dropDownH = 140;
        this.dropDownManager.clearDropDowns();
        if (this.selection.getType() == QuestElementType.OBJECTIVE) {
            this.addDropDown(new DropDown<int>((List<int>)QuestEditorState.get().getObjectives(), QuestEditorState.get().getObjectives().indexOf(QuestEditorState.get().getObjective(this.selection.getIdentifier())), dropDownX, dropDownY, dropDownW, dropDownH, dropDownW - 6).setGetOptionString(qe -> I18n.m_118936_((String)qe.getName()) ? I18n.m_118938_((String)qe.getName(), (Object[])new Object[0]) : qe.getIdentifier()).setOrdered().setOnSelected(e -> this.selection.duplicate((QuestElement)e)));
        } else if (this.selection.getType() == QuestElementType.ACTION) {
            this.addDropDown(new DropDown<int>((List<int>)QuestEditorState.get().getActions(), QuestEditorState.get().getActions().indexOf(QuestEditorState.get().getAction(this.selection.getIdentifier())), dropDownX, dropDownY, dropDownW, dropDownH, dropDownW - 6).setGetOptionString(qe -> I18n.m_118936_((String)qe.getName()) ? I18n.m_118938_((String)qe.getName(), (Object[])new Object[0]) : qe.getIdentifier()).setOrdered().setOnSelected(e -> this.selection.duplicate((QuestElement)e)));
        }
    }

    private void deleteElement(QuestElement element) {
        if (this.objectives.remove(element)) {
            Quest quest = QuestEditorState.get().getSelectedQuest();
            quest.clearDefaultStrings(this.stage.getStage(), this.objectives.size());
            this.actionObjectives.remove(this.objectives.size());
        }
        this.actions.remove(element);
        if (this.selection == element) {
            this.selection = null;
        }
    }

    private int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.dropDownManager.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        if (mouseX >= (double)(x + 60) && mouseX <= (double)(x + 60 + 16) && mouseY >= (double)(y + 4) && mouseY <= (double)(y + 4 + 16)) {
            this.stage.changeIcon();
            return true;
        }
        int id = -1;
        for (SimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            switch (id) {
                case 0: {
                    this.writeToStage();
                    this.f_96541_.m_91152_((Screen)new QuestOverviewScreen());
                    break;
                }
                case 1: {
                    this.writeToStage();
                    break;
                }
                case 2: {
                    this.f_96541_.m_91152_((Screen)new QuestOverviewScreen());
                }
            }
        }
        if (this.selection != null) {
            this.selection.onClick(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    private void writeToStage() {
        this.writeExtraString(this.selection);
        Quest quest = QuestEditorState.get().getSelectedQuest();
        this.stage.getRawObjectives().clear();
        int oi = 0;
        for (QuestElement element : this.objectives) {
            this.stage.getRawObjectives().add(element.build(quest, this.stage, oi++));
        }
        this.stage.getRawActions().clear();
        int ai = 0;
        for (QuestElement element : this.actions) {
            this.stage.getRawActions().add(element.build(quest, this.stage, ai++));
        }
        quest.setDefaultStrings(this.stage.getStage(), this.stage.getRawObjectives().size());
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        boolean val = super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
        if (this.selection != null) {
            this.selection.onType(Character.forDigit(p_231046_1_, p_231046_1_), p_231046_1_);
        }
        return val;
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY == 120.0) {
            this.onScroll(Direction.DOWN, mouseX, mouseY);
        } else if (deltaY == -120.0) {
            this.onScroll(Direction.UP, mouseX, mouseY);
        }
        return true;
    }

    private void onScroll(Direction direction, double mouseX, double mouseY) {
    }

    public void m_86600_() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.f_96541_.m_91152_((Screen)new QuestEditorScreen());
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.f_96543_ != this.prevWidth || this.f_96544_ != this.prevHeight)) {
            this.addButtons();
            if (this.selection != null) {
                int x = this.f_96543_ / 2 - 125;
                int y = this.f_96544_ / 2 - 100;
                int xOffset = 20;
                int yOffset = 20;
                int dispWidth = xOffset + 230;
                int dispHeight = yOffset + 180;
                this.selection.initialize(this.f_96541_, x, y, dispWidth, dispHeight);
                this.setDropDowns(x, y, dispWidth, dispHeight);
            }
        }
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.reload = false;
        }
        this.prevWidth = this.f_96543_;
        this.prevHeight = this.f_96544_;
    }

    public <T> DropDown<T> addDropDown(DropDown<T> dropDown) {
        this.dropDownManager.addDropDown(dropDown);
        return dropDown;
    }

    public void removeDropDown(DropDown dropDown) {
        this.dropDownManager.removeDropDown(dropDown);
    }

    private static enum MouseState {
        HOVER,
        PRESS,
        DRAG,
        RELEASE;

    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

