/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestStageScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestStringsScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.SimpleButton;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.TextField;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class QuestOverviewScreen
extends Screen {
    private List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private TextField questName;
    private String oldName;
    private int globalQuestOption = -1;
    private MouseState mouseState = MouseState.HOVER;
    private Stage draggedStage = null;
    private Stage hoverStage = null;
    private int ticker = 0;
    private final int[] addStageButtonLoc = new int[]{0, 0, 0, 0};
    private boolean changingHue = false;
    private boolean changingColor = false;
    private float[] hsb = null;
    private int hoveringColor = -1;
    private boolean reload = false;

    public QuestOverviewScreen() {
        super((Component)Component.m_237119_());
        this.oldName = QuestEditorState.get().getSelectedQuest().getFilename();
    }

    public void m_7856_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        float titleBorder = 5.5f;
        this.questName = new TextField(this.f_96541_.f_91062_, (int)((float)(x + gap) + (float)dispWidth / 2.0f) - 23, (int)((float)y + titleBorder), 115, 14, -6908266, -7895161);
        this.questName.setTextColor(Color.WHITE.getRGB());
        Quest quest = QuestEditorState.get().getSelectedQuest();
        if (quest != null) {
            this.questName.setText(quest.getPrintableName());
        }
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int id = 0;
        int buttonS = 14;
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 0, y + 6, 12, Resources.back, 2, 2, -12407307));
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 1, y + 6, 12, Resources.save, 2, 2, -14300093));
        this.buttons.add(new SimpleButton(id++, x + 4 + (buttonS + 6) * 2, y + 6, 12, Resources.discard, 2, 2, -2210481));
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float f) {
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        Quest quest = QuestEditorState.get().getSelectedQuest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        super.m_88315_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        matrix.m_280163_(Resources.backgroundTexture, x - gap, y, 0.0f, 0.0f, dispWidth + gap * 2 + 1, dispHeight, dispWidth, dispHeight);
        this.drawColorPicker(matrix, dispWidth, dispHeight, mouseX, mouseY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        float titleBorder = 8.5f;
        QuestColor color = quest.getColor();
        matrix.m_280246_(color.floatR(), color.floatG(), color.floatB(), 1.0f);
        matrix.m_280163_(quest.getStages().get(quest.getStages().size() - 1).getStage() == quest.getActiveStage() ? Resources.question_mark : Resources.exclamation_mark, (int)((float)(x + gap) + (float)dispWidth / 2.0f) - 41, (int)((float)y + titleBorder) - 4, 0.0f, 0.0f, 16, 16, 16, 16);
        this.drawStages(matrix, x, y, mouseX, mouseY);
        float textX = (float)x + (float)dispWidth / 4.0f * 3.0f - 2.0f;
        float textY = y + 130;
        float spacing = 14.0f;
        int buttonSize = 40;
        int tickerColor = this.ticker % 200 < 100 ? 0 : 0xFFFFFF;
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.questeditor.weight", (Object[])new Object[]{String.valueOf(quest.getWeight())}), textX, textY, this.globalQuestOption == 0 ? tickerColor : 0);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)(quest.isAbandonable() ? "gui.questeditor.abandonable" : "gui.questeditor.notabandonable"), (Object[])new Object[0]), textX, textY + spacing, this.globalQuestOption == 1 ? tickerColor : 0);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)(quest.isRepeatable() ? "gui.questeditor.repeatable" : "gui.questeditor.notrepeatable"), (Object[])new Object[0]), textX, textY + spacing * 2.0f, this.globalQuestOption == 2 ? tickerColor : 0);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.questeditor.edittext", (Object[])new Object[0]), textX, textY + spacing * 3.0f, this.globalQuestOption == 3 ? tickerColor : 0);
        boolean optionHovering = false;
        if ((float)mouseX >= textX - (float)buttonSize && (float)mouseX <= textX + (float)buttonSize) {
            for (int i = 0; i < 4; ++i) {
                if (!((float)mouseY >= textY + spacing * (float)i) || !((float)mouseY <= textY + spacing * (float)i + 6.0f)) continue;
                optionHovering = true;
                this.globalQuestOption = i;
            }
        }
        if (!optionHovering) {
            this.globalQuestOption = -1;
        }
        RenderSystem.disableBlend();
        for (SimpleButton button : this.buttons) {
            button.renderWidget(matrix);
        }
        this.questName.m_87963_(matrix, mouseX, mouseY, Minecraft.m_91087_().m_91296_());
    }

    private void drawStages(GuiGraphics matrix, int x, int y, int mouseX, int mouseY) {
        boolean mouseDown = Minecraft.m_91087_().f_91067_.m_91560_();
        if (mouseDown) {
            if (this.mouseState == MouseState.HOVER) {
                this.mouseState = MouseState.PRESS;
            } else if (this.mouseState == MouseState.PRESS) {
                this.mouseState = MouseState.DRAG;
            }
        } else if (this.mouseState == MouseState.PRESS || this.mouseState == MouseState.DRAG) {
            this.mouseState = MouseState.RELEASE;
        } else if (this.mouseState == MouseState.RELEASE) {
            this.mouseState = MouseState.HOVER;
            this.draggedStage = null;
        }
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        Quest quest = QuestEditorState.get().getSelectedQuest();
        int[] editDropZone = new int[]{x + dispWidth / 2 - 50, y + 90, x + dispWidth / 2 - 5, y + 110};
        int[] deleteDropZone = new int[]{x + dispWidth / 2 + 5, y + 90, x + dispWidth / 2 + 50, y + 110};
        boolean isHoverEdit = this.draggedStage != null && mouseX >= editDropZone[0] && mouseY >= editDropZone[1] && mouseX <= editDropZone[2] && mouseY <= editDropZone[3];
        boolean isHoverDelete = quest.getStages().size() > 1 && this.draggedStage != null && mouseX >= deleteDropZone[0] && mouseY >= deleteDropZone[1] && mouseX <= deleteDropZone[2] && mouseY <= deleteDropZone[3];
        matrix.m_280509_(editDropZone[0], editDropZone[1], editDropZone[2], editDropZone[3], isHoverEdit || this.draggedStage != null && this.ticker % 200 < 100 ? -16727066 : -10066330);
        matrix.m_280509_(deleteDropZone[0], deleteDropZone[1], deleteDropZone[2], deleteDropZone[3], isHoverDelete || quest.getStages().size() > 1 && this.draggedStage != null && this.ticker % 200 < 100 ? -2210481 : -10066330);
        ScreenHelper.drawCenteredString(matrix, this.f_96547_, I18n.m_118938_((String)"gui.questeditor.editstage", (Object[])new Object[0]), (float)(editDropZone[0] + editDropZone[2]) / 2.0f, (float)(y + 96), 0xFFFFFF, true);
        ScreenHelper.drawCenteredString(matrix, this.f_96547_, I18n.m_118938_((String)"gui.questeditor.removestage", (Object[])new Object[0]), (float)(deleteDropZone[0] + deleteDropZone[2]) / 2.0f, (float)(y + 96), 0xFFFFFF, true);
        int stageCount = quest.getStages().size();
        int gap = dispWidth / (stageCount + 1);
        if (this.draggedStage != null && this.mouseState == MouseState.RELEASE) {
            if (isHoverEdit) {
                this.f_96541_.m_91152_((Screen)new QuestStageScreen(this.draggedStage));
            } else if (isHoverDelete) {
                for (Stage stage : quest.getStages()) {
                    if (stage.getNextStage() != this.draggedStage.getStage()) continue;
                    stage.setNextStage(this.draggedStage.getNextStage());
                }
                quest.getStages().remove(this.draggedStage);
                quest.clearDefaultStrings(this.draggedStage.getStage(), this.draggedStage.getRawObjectives().size());
            }
        }
        boolean hovering = false;
        int index = 1;
        for (Stage stage : quest.getStages()) {
            boolean mouseOver = this.drawStage(matrix, stage, quest.getNextStage(stage.getStage()), this.draggedStage == stage, x + gap * index, y + 45, gap, mouseX, mouseY);
            if (mouseOver) {
                hovering = true;
                this.hoverStage = stage;
                if (this.mouseState == MouseState.PRESS) {
                    this.draggedStage = stage;
                } else if (this.mouseState == MouseState.RELEASE) {
                    if (this.draggedStage != null) {
                        Stage a = this.draggedStage;
                        Stage b = stage;
                        ArrayList<String> oa = new ArrayList<String>(a.getRawObjectives());
                        ArrayList<String> aa = new ArrayList<String>(a.getRawActions());
                        ArrayList<String> ob = new ArrayList<String>(b.getRawObjectives());
                        ArrayList<String> ab = new ArrayList<String>(b.getRawActions());
                        a.getRawObjectives().clear();
                        a.getRawObjectives().addAll(ob);
                        a.getRawActions().clear();
                        a.getRawActions().addAll(ab);
                        b.getRawObjectives().clear();
                        b.getRawObjectives().addAll(oa);
                        b.getRawActions().clear();
                        b.getRawActions().addAll(aa);
                    }
                    this.draggedStage = null;
                }
            }
            ++index;
        }
        if (!hovering) {
            this.hoverStage = null;
        }
        ++this.ticker;
    }

    private boolean drawStage(GuiGraphics matrix, Stage stage, Stage nextStage, boolean dragged, int x, int y, int gap, int mouseX, int mouseY) {
        int width = 6;
        int height = 30;
        int left = x - width / 2 - 1;
        int top = y - 1;
        int right = x + width + 1;
        int bottom = y + height + 2;
        if (dragged) {
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
        }
        matrix.m_280509_(left, top, right, bottom, -16777216);
        ScreenHelper.drawCenteredString(matrix, String.valueOf(stage.getStage()), (float)(x + 2), (float)(y - 10), this.hoverStage == stage && this.draggedStage == null ? (this.ticker % 200 < 100 ? 0 : 0xFFFFFF) : 0);
        boolean activeStage = QuestEditorState.get().getSelectedQuest().getActiveStage() == stage.getStage();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (activeStage) {
            matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            float grey = 0.4f;
            matrix.m_280246_(grey, grey, grey, 1.0f);
            if (this.mouseState == MouseState.PRESS && mouseX >= x - 4 && mouseX <= x + 7 && mouseY >= y + height + 1 && mouseY <= y + height + 15) {
                QuestEditorState.get().getSelectedQuest().setActiveStage(stage.getStage());
            }
        }
        matrix.m_280163_(activeStage ? Resources.eyeTexture : Resources.eyeClosedTexture, x - 4, y + height + 1, 0.0f, 0.0f, 11, 11, 11, 11);
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (stage.getStage() == 0) {
            matrix.m_280509_(x - 10, y + height / 2 - 1, x - 4, y + height / 2 + 2, -1);
            this.addStageButtonLoc[0] = x - 19;
            this.addStageButtonLoc[1] = y + height / 2 - 4;
            this.addStageButtonLoc[2] = x - 10;
            this.addStageButtonLoc[3] = y + height / 2 + 5;
            matrix.m_280509_(this.addStageButtonLoc[0], this.addStageButtonLoc[1], this.addStageButtonLoc[2], this.addStageButtonLoc[3], -1);
            matrix.m_280509_(x - 17, y + height / 2, x - 12, y + height / 2 + 1, -16777216);
            matrix.m_280509_(x - 15, y + height / 2 - 2, x - 14, y + height / 2 + 3, -16777216);
        }
        if (nextStage != null) {
            matrix.m_280509_(x + 7, y + height / 2 - 1, x + gap - 4, y + height / 2 + 2, -1);
        } else {
            matrix.m_280509_(x + 7, y + height / 2 - 1, x + 13, y + height / 2 + 2, -1);
            matrix.m_280509_(x + 13, y + height / 2 - 3, x + 15, y + height / 2 + 4, -1);
        }
        if (dragged) {
            x = mouseX;
            y = mouseY - height / 2;
        }
        matrix.m_280509_(x - width / 2 - 1, y - 1, x + width + 1, y + height + 2, -16777216);
        matrix.m_280509_(x - width / 2, y, x + width, y + height / 2, -17664);
        matrix.m_280509_(x - width / 2, y + height / 2 + 1, x + width, y + height + 1, -5479425);
        ScreenHelper.drawCenteredString(matrix, String.valueOf(stage.getRawObjectives().size()), (float)(x + 2), (float)y + (float)height / 2.0f - 11.0f, 0);
        ScreenHelper.drawCenteredString(matrix, String.valueOf(stage.getRawActions().size()), (float)(x + 2), (float)(y + height - 10), 0);
        if (dragged) {
            matrix.m_280168_().m_85849_();
        }
        return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
    }

    private void drawColorPicker(GuiGraphics matrix, int dispWidth, int dispHeight, int mouseX, int mouseY) {
        Quest quest = QuestEditorState.get().getSelectedQuest();
        if (this.hsb == null) {
            this.hsb = new float[3];
            Color.RGBtoHSB(quest.getColor().getR(), quest.getColor().getG(), quest.getColor().getB(), this.hsb);
        }
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int left = x + 5;
        int top = y + 117;
        int width = 100;
        int height = 55;
        for (int i = 0; i < width; ++i) {
            float v1 = (float)i / (float)width;
            float v2 = (float)((double)i + 0.5) / (float)width;
            ScreenHelper.drawGradientRect(matrix, left + i, top, 1.0f, left + i + 1, top + height, Color.HSBtoRGB(this.hsb[0], v1, 1.0f), Color.BLACK.getRGB(), false);
            ScreenHelper.drawGradientRect(matrix, left + i, top + height + 4, 1.0f, left + i + 1, top + height + 12, Color.HSBtoRGB(v1, 1.0f, 1.0f), Color.HSBtoRGB(v2, 1.0f, 1.0f), true);
        }
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int newColor = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        Color color = new Color(newColor);
        matrix.m_280509_(left + width + 3, top, left + width + 13, top + height + 23, -16777216);
        matrix.m_280509_(left + width + 3 + 1, top + 1, left + width + 13 - 1, top + height + 23 - 1, newColor);
        int tickerColor = this.ticker % 200 < 100 ? 0 : 0xFFFFFF;
        int rgbSpacing = 37;
        matrix.m_280488_(this.f_96547_, "R", left, top + height + 16, 0);
        matrix.m_280488_(this.f_96547_, String.valueOf(color.getRed()), left + 8, top + height + 16, this.hoveringColor == 0 ? tickerColor : 0);
        matrix.m_280488_(this.f_96547_, "G", left + rgbSpacing, top + height + 16, 0);
        matrix.m_280488_(this.f_96547_, String.valueOf(color.getGreen()), left + rgbSpacing + 8, top + height + 16, this.hoveringColor == 1 ? tickerColor : 0);
        matrix.m_280488_(this.f_96547_, "B", left + rgbSpacing * 2, top + height + 16, 0);
        matrix.m_280488_(this.f_96547_, String.valueOf(color.getBlue()), left + rgbSpacing * 2 + 8, top + height + 16, this.hoveringColor == 2 ? tickerColor : 0);
        if (this.mouseState == MouseState.PRESS) {
            if (mouseX >= left && mouseX <= left + width && mouseY >= top && mouseY <= top + height) {
                this.changingColor = true;
            } else if (mouseX >= left && mouseX <= left + width && mouseY >= top + height + 4 && mouseY <= top + height + 12) {
                this.changingHue = true;
            }
        } else if (this.mouseState == MouseState.RELEASE) {
            if (this.changingColor || this.changingHue) {
                // empty if block
            }
            this.changingColor = false;
            this.changingHue = false;
        } else if (this.mouseState == MouseState.DRAG && (this.changingColor || this.changingHue)) {
            int boundedMouseX = this.bound(mouseX, left, left + width);
            int boundedMouseY = this.bound(mouseY, top, top + height);
            float colorX = (float)(boundedMouseX - left) / (float)width;
            float colorY = (float)(boundedMouseY - top) / (float)height;
            if (this.changingColor) {
                this.hsb[1] = colorX;
                this.hsb[2] = 1.0f - colorY;
            } else if (this.changingHue) {
                this.hsb[0] = colorX;
                boundedMouseY = top + height + 8;
            }
            int fullbrightColor = Color.HSBtoRGB(this.hsb[0], 1.0f, 1.0f);
            QuestColor newQuestColor = new QuestColor(newColor);
            quest.setColor(newQuestColor);
            int size = 12;
            int border = 1;
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
            matrix.m_280509_(boundedMouseX - border - size / 2, boundedMouseY - border - size / 2, boundedMouseX + size / 2 + border, boundedMouseY + size / 2 + border, -16777216);
            matrix.m_280509_(boundedMouseX - size / 2, boundedMouseY - size / 2, boundedMouseX + size / 2, boundedMouseY + size / 2, this.changingColor ? newColor : fullbrightColor);
            matrix.m_280168_().m_85849_();
        } else {
            boolean set = false;
            for (int i = 0; i < 3; ++i) {
                if (mouseX < left + rgbSpacing * i || mouseX > left + rgbSpacing * i + 24 || mouseY < top + height + 16 || mouseY > top + height + 16 + 6) continue;
                this.hoveringColor = i;
                set = true;
                break;
            }
            if (!set) {
                this.hoveringColor = -1;
            }
        }
    }

    private int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int id = -1;
        for (SimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            switch (id) {
                case 0: {
                    QuestEditorState.get().push(this.oldName, QuestEditorState.get().getSelectedQuest(), true);
                    this.oldName = QuestEditorState.get().getSelectedQuest().getFilename();
                    break;
                }
                case 1: {
                    QuestEditorState.get().push(this.oldName, QuestEditorState.get().getSelectedQuest(), false);
                    this.oldName = QuestEditorState.get().getSelectedQuest().getFilename();
                    break;
                }
                case 2: {
                    QuestEditorState.get().fetch(false);
                    this.reload = true;
                }
            }
        }
        if (mouseX >= (double)this.addStageButtonLoc[0] && mouseY >= (double)this.addStageButtonLoc[1] && mouseX <= (double)this.addStageButtonLoc[2] && mouseY <= (double)this.addStageButtonLoc[3]) {
            QuestEditorState.get().addNewStage();
        }
        if (this.globalQuestOption != -1) {
            switch (this.globalQuestOption) {
                case 1: {
                    QuestEditorState.get().getSelectedQuest().toggleAbandonability();
                    break;
                }
                case 2: {
                    QuestEditorState.get().getSelectedQuest().toggleRepeatability();
                    break;
                }
                case 3: {
                    this.f_96541_.m_91152_((Screen)new QuestStringsScreen());
                }
            }
        }
        this.questName.m_6375_(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean m_7933_(int c, int i, int modifiers) {
        boolean val = super.m_7933_(c, i, modifiers);
        if (this.questName.m_93696_() && this.questName.m_5534_(Character.highSurrogate(c), i)) {
            QuestEditorState.get().getSelectedQuest().setFilename(this.questName.getText() + ".json");
        }
        return val;
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY == 120.0) {
            this.onScroll(Direction.DOWN, mouseX, mouseY);
        } else if (deltaY == -120.0) {
            this.onScroll(Direction.UP, mouseX, mouseY);
        }
        return true;
    }

    private void onScroll(Direction direction, double mouseX, double mouseY) {
        int change;
        short oldStageValue;
        short newStageValue;
        if (this.changingColor || this.changingHue) {
            return;
        }
        if (this.hoverStage != null && (newStageValue = (short)((oldStageValue = this.hoverStage.getStage()) + (direction == Direction.UP ? 1 : -1))) >= 0 && newStageValue < Short.MAX_VALUE && oldStageValue != newStageValue) {
            Quest quest = QuestEditorState.get().getSelectedQuest();
            Stage replacing = quest.getStage(newStageValue);
            if (replacing != null) {
                short sA = this.hoverStage.getStage();
                short nsA = this.hoverStage.getNextStage();
                short sB = replacing.getStage();
                short nsB = replacing.getNextStage();
                this.hoverStage.setStage(sB);
                this.hoverStage.setNextStage(nsB);
                replacing.setStage(sA);
                replacing.setNextStage(nsA);
            } else if (oldStageValue != 0 || newStageValue != 1) {
                this.hoverStage.setStage(newStageValue);
                for (Stage stage : quest.getStages()) {
                    if (stage.getNextStage() != oldStageValue) continue;
                    stage.setNextStage(newStageValue);
                }
                quest.clearDefaultStrings(oldStageValue, this.hoverStage.getRawObjectives().size());
                quest.setDefaultStrings(newStageValue, this.hoverStage.getRawObjectives().size());
            }
            quest.getStages().sort(Comparator.comparing(Stage::getStage));
        }
        if (this.hoveringColor != -1) {
            change = direction == Direction.DOWN ? -1 : 1;
            int rgb = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
            Color color = new Color(rgb);
            QuestColor newColor = new QuestColor(this.bound(color.getRed() + (this.hoveringColor == 0 ? change : 0), 0, 255), this.bound(color.getGreen() + (this.hoveringColor == 1 ? change : 0), 0, 255), this.bound(color.getBlue() + (this.hoveringColor == 2 ? change : 0), 0, 255));
            QuestEditorState.get().getSelectedQuest().setColor(newColor);
            Color.RGBtoHSB(newColor.getR(), newColor.getG(), newColor.getB(), this.hsb);
        }
        if (this.globalQuestOption == 0) {
            change = direction == Direction.DOWN ? -1 : 1;
            QuestEditorState.get().getSelectedQuest().setWeight(QuestEditorState.get().getSelectedQuest().getWeight() + change);
        }
    }

    private void refreshQuest() {
        for (Quest quest : QuestEditorState.get().getAllQuests()) {
            if (!quest.getFilename().equalsIgnoreCase(this.oldName)) continue;
            QuestEditorState.get().selectQuest(quest);
            this.f_96541_.m_91152_((Screen)new QuestOverviewScreen());
            break;
        }
    }

    public void m_86600_() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.f_96541_.m_91152_((Screen)new QuestEditorScreen());
        }
        this.addButtons();
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.refreshQuest();
            this.reload = false;
        }
    }

    private static enum MouseState {
        HOVER,
        PRESS,
        DRAG,
        RELEASE;

    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

