/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestOverviewScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.ListQuestEditor;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.SimpleButton;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.TextField;
import com.pixelmonmod.pixelmon.quests.comm.editor.ReloadQuestDataPacket;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class QuestEditorScreen
extends Screen {
    private List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private ListQuestEditor questList;
    private TextField newQuest;
    private boolean canMakeQuest = false;
    private String madeQuest = "";
    private Quest selected = null;
    int prevWidth = -1;
    int prevHeight = -1;

    public QuestEditorScreen() {
        super((Component)Component.m_237119_());
    }

    public QuestEditorScreen(Quest selected) {
        super((Component)Component.m_237119_());
        this.selected = selected;
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int buttonS = 14;
        this.buttons.add(new SimpleButton(0, x + 4, y + 6, 12, Resources.refresh, 2, 2, -5635841));
    }

    public void m_7856_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int newQuestY = y + dispHeight - 35 + 7;
        this.questList = new ListQuestEditor(this.f_96541_.f_91062_, x + 7, y + 23, 104, 9);
        this.questList.m_93692_(true);
        this.newQuest = new TextField(this.f_96541_.f_91062_, x + 1, newQuestY + 4, 95, 20, -6908266, -7895161);
        this.newQuest.setTextColor(14889216);
        this.refreshQuests();
        if (this.selected != null) {
            boolean found = false;
            for (Quest quest : QuestEditorState.get().getAllQuests()) {
                if (!quest.getPrintableName().equalsIgnoreCase(this.selected.getPrintableName())) continue;
                this.selected = quest;
                found = true;
                break;
            }
            if (found) {
                int lineindex = this.questList.lines.indexOf(this.selected);
                this.questList.selectQuest(lineindex);
                if (lineindex >= 0 && lineindex < this.questList.lines.size()) {
                    QuestEditorState.get().selectQuest(this.questList.lines.get(lineindex));
                } else {
                    QuestEditorState.get().selectQuest(null);
                }
            }
            this.selected = null;
        }
        this.addButtons();
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float f) {
        int qlh;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        super.m_88315_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        ScreenHelper.bindTexture(Resources.backgroundTexture);
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        this.questList.height = qlh = 132;
        this.questList.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        int newQuestGap = 35;
        matrix.m_280163_(Resources.backgroundTexture, x + dispWidth / 2 + gap + 1, y, 0.0f, 0.0f, dispWidth / 2, dispHeight, (int)((float)dispWidth / 2.0f), dispHeight);
        matrix.m_280163_(Resources.backgroundTexture, x - gap, y, 0.0f, 0.0f, dispWidth / 2, dispHeight - newQuestGap, (int)((float)dispWidth / 2.0f), dispHeight - newQuestGap);
        int newQuestY = y + dispHeight - newQuestGap + 7;
        matrix.m_280163_(Resources.backgroundTexture, x - gap, newQuestY, 0.0f, 0.0f, dispWidth / 2, dispHeight - (dispHeight - newQuestGap) - 7, (int)((float)dispWidth / 2.0f), dispHeight - 30);
        String textA = ChatFormatting.BOLD + I18n.m_118938_((String)"gui.questeditor.title", (Object[])new Object[0]);
        matrix.drawString(this.f_96547_, textA, (float)(x - gap) + (float)dispWidth / 4.0f - (float)this.f_96547_.m_92895_(textA) / 2.0f, (float)y + 8.5f, 0xFFFFFF, true);
        this.questList.drawBackground(matrix);
        this.questList.drawText(matrix);
        this.newQuest.m_87963_(matrix, mouseX, mouseY, Minecraft.m_91087_().m_91296_());
        float titleBorder = 8.5f;
        if (QuestEditorState.get().hasQuestSelected()) {
            Quest selectedQuest = QuestEditorState.get().getSelectedQuest();
            String title = selectedQuest.getPrintableName();
            int strWidth = this.f_96547_.m_92895_(title);
            double wf = 95.0;
            double finalWidth = Math.min((double)strWidth, wf - 6.0);
            ScreenHelper.drawSquashedString(matrix, this.f_96547_, title, false, (float)wf, (float)((int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0 + 6.0)), (float)((int)((float)y + titleBorder)), 0xFFFFFF, true);
            QuestColor color = selectedQuest.getColor();
            matrix.m_280246_(color.floatR(), color.floatG(), color.floatB(), 1.0f);
            matrix.m_280163_(selectedQuest.getStages().get(selectedQuest.getStages().size() - 1).getStage() == selectedQuest.getActiveStage() ? Resources.question_mark : Resources.exclamation_mark, (int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0) - 11, (int)((float)y + titleBorder) - 4, 0.0f, 0.0f, 16, 16, 16, 16);
            for (int i = 0; i < 4; ++i) {
                int buttonW = 50;
                int buttonH = 30;
                int buttonX = x + (int)((float)dispWidth / 4.0f * 3.0f) + gap + 1 - buttonW / 2;
                int buttonY = y + 30 + i * 42;
                String text = "";
                switch (i) {
                    case 0: {
                        matrix.m_280509_(buttonX, buttonY, buttonX + buttonW, buttonY + buttonH, -16727066);
                        text = I18n.m_118938_((String)"gui.questeditor.edit", (Object[])new Object[0]);
                        break;
                    }
                    case 1: {
                        matrix.m_280509_(buttonX, buttonY, buttonX + buttonW, buttonY + buttonH, -10263709);
                        text = I18n.m_118938_((String)"gui.questeditor.test", (Object[])new Object[0]);
                        break;
                    }
                    case 2: {
                        matrix.m_280509_(buttonX, buttonY, buttonX + buttonW, buttonY + buttonH, -6029082);
                        text = I18n.m_118938_((String)"gui.questeditor.clone", (Object[])new Object[0]);
                        break;
                    }
                    case 3: {
                        matrix.m_280509_(buttonX, buttonY, buttonX + buttonW, buttonY + buttonH, -2424803);
                        text = I18n.m_118938_((String)"gui.questeditor.delete", (Object[])new Object[0]);
                    }
                }
                int textWidth = this.f_96547_.m_92895_(text);
                ScreenHelper.drawSquashedString(matrix, this.f_96547_, text, false, (float)wf, (float)((int)((float)buttonX - (float)textWidth / 2.0f + (float)buttonW / 2.0f)), (float)((int)((float)(buttonY - 4) + (float)buttonH / 2.0f)), 0xFFFFFF, true);
            }
        } else {
            String title = I18n.m_118938_((String)"gui.questeditor.noselection", (Object[])new Object[0]);
            int strWidth = this.f_96547_.m_92895_(title);
            ScreenHelper.drawSquashedString(matrix, this.f_96547_, title, false, (float)strWidth, (float)((int)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f - (float)strWidth / 2.0f)), (float)((int)((float)y + titleBorder)), 0xFFFFFF, true);
        }
        int addQuestX = x + 104;
        int addQuestY = y + dispHeight - 19;
        int size = 10;
        matrix.m_280509_(addQuestX, addQuestY, addQuestX + size, addQuestY + size, this.canMakeQuest ? -16724221 : -10066330);
        matrix.drawString(this.f_96547_, "+", (float)addQuestX + (float)size / 2.0f - 2.5f, (float)addQuestY + (float)size / 2.0f - 3.5f, 0xFFFFFF, true);
        for (SimpleButton button : this.buttons) {
            button.renderWidget(matrix);
        }
        RenderSystem.disableBlend();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        Quest clickedOnQuest;
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.f_96543_ / 2 - 125;
        int y = this.f_96544_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int sliderSpeed = 5;
        if (this.canMakeQuest) {
            int addQuestX = x + 104;
            int addQuestY = y + dispHeight - 19;
            int size = 10;
            if (mouseX >= (double)addQuestX && mouseX <= (double)(addQuestX + size) && mouseY >= (double)addQuestY && mouseY <= (double)(addQuestY + size)) {
                String questName = this.newQuest.getText() + ".json";
                this.madeQuest = questName;
                QuestEditorState.get().push(questName, new Quest(questName), false);
                this.canMakeQuest = false;
            }
        }
        if (QuestEditorState.get().hasQuestSelected()) {
            Quest selectedQuest = QuestEditorState.get().getSelectedQuest();
            block6: for (int i = 0; i < 4; ++i) {
                int buttonW = 50;
                int buttonH = 30;
                int buttonX = x + (int)((float)dispWidth / 4.0f * 3.0f) + gap + 1 - buttonW / 2;
                int buttonY = y + 30 + i * 42;
                if (!(mouseX >= (double)buttonX) || !(mouseX <= (double)(buttonX + buttonW)) || !(mouseY >= (double)buttonY) || !(mouseY <= (double)(buttonY + buttonH))) continue;
                switch (i) {
                    case 0: {
                        this.f_96541_.m_91152_((Screen)new QuestOverviewScreen());
                        continue block6;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        StringBuilder copy = new StringBuilder("Copy");
                        while (QuestEditorState.get().hasQuest(selectedQuest.getPrintableName() + " " + copy.toString())) {
                            copy.append(" Copy");
                        }
                        Quest newQuest = new Quest(selectedQuest, selectedQuest.getPrintableName() + " " + copy.toString() + ".json");
                        this.madeQuest = newQuest.getFilename();
                        QuestEditorState.get().push(newQuest.getFilename(), newQuest, false);
                        continue block6;
                    }
                    case 3: {
                        QuestEditorState.get().delete(selectedQuest);
                    }
                }
            }
        }
        if ((clickedOnQuest = this.questList.mouseClicked(mouseX, mouseY, 0, this.questList.yPos + 8)) != null) {
            int lineindex = this.questList.lines.indexOf(clickedOnQuest);
            this.questList.selectQuest(lineindex);
            if (lineindex >= 0 && lineindex < this.questList.lines.size()) {
                QuestEditorState.get().selectQuest(this.questList.lines.get(lineindex));
            } else {
                QuestEditorState.get().selectQuest(null);
            }
        }
        int id = -1;
        for (SimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id == 0) {
            NetworkHelper.sendToServer(new ReloadQuestDataPacket());
        }
        this.newQuest.m_6375_(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean returnVal = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.newQuest.m_93696_() && this.newQuest.m_5534_(Character.forDigit(keyCode, scanCode), modifiers)) {
            this.updateNewQuestBox();
        }
        return returnVal;
    }

    public void updateNewQuestBox() {
        this.refreshQuests();
        if (this.newQuest.getText().isEmpty()) {
            this.newQuest.setTextColor(14889216);
            this.canMakeQuest = false;
            return;
        }
        String filename = this.newQuest.getText().replace(" ", "_");
        for (Quest quest : QuestEditorState.get().getAllQuests()) {
            if (!quest.getIdentityName().equalsIgnoreCase(filename)) continue;
            this.newQuest.setTextColor(14889216);
            this.canMakeQuest = false;
            return;
        }
        this.newQuest.setTextColor(Color.WHITE.getRGB());
        this.canMakeQuest = true;
    }

    public void refreshQuests() {
        int size = this.questList.lines.size();
        this.questList.lines.clear();
        for (Quest quest : QuestEditorState.get().getAllQuests()) {
            this.questList.addLine(quest);
        }
        this.questList.sort(this.newQuest.getText());
        if (size > this.questList.lines.size()) {
            this.questList.selectQuest(-1);
            QuestEditorState.get().selectQuest(null);
        }
        if (!this.madeQuest.isEmpty()) {
            int i = 0;
            for (Quest quest : this.questList.lines) {
                if (quest.getFilename().equalsIgnoreCase(this.madeQuest)) {
                    QuestEditorState.get().selectQuest(quest);
                    this.questList.selectQuest(i);
                    break;
                }
                ++i;
            }
            this.madeQuest = "";
        }
        if (Math.abs(size - this.questList.lines.size()) > 1) {
            this.questList.startLine = 0;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY == 120.0) {
            if (this.questList.isFocused) {
                this.questList.scrollDown();
            }
        } else if (deltaY == -120.0 && this.questList.isFocused) {
            this.questList.scrollUp();
        }
        return true;
    }

    public void m_86600_() {
        if (QuestEditorState.get().isDirty()) {
            this.refreshQuests();
            this.updateNewQuestBox();
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.f_96543_ != this.prevWidth || this.f_96544_ != this.prevHeight)) {
            this.addButtons();
        }
        this.prevWidth = this.f_96543_;
        this.prevHeight = this.f_96544_;
    }
}

