/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClientData;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.StageIcon;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;

public class QuestProgressClient
extends QuestProgressClientData {
    public QuestProgressClient() {
    }

    public QuestProgressClient(FriendlyByteBuf buf) {
        this.read(buf);
    }

    public String format(ObjectiveDetail detail) {
        return this.format(detail.getKey(), detail);
    }

    public String format(String key) {
        return this.format(key, null);
    }

    public String format(String key, @Nullable ObjectiveDetail detail) {
        String text;
        if (key == null) {
            key = "";
        }
        String string = text = I18n.m_118936_((String)key) ? I18n.m_118938_((String)key, (Object[])new Object[0]) : key;
        if (key.endsWith(".name") && (text == null || text.equals(key))) {
            String string2 = text = I18n.m_118936_((String)key.replace(".name", "")) ? I18n.m_118938_((String)key.replace(".name", ""), (Object[])new Object[0]) : key;
        }
        if (text.startsWith("quest.") || text.isEmpty()) {
            return "";
        }
        if (detail != null) {
            text = detail.applyPlaceholders(text);
        }
        if (text.contains("?")) {
            for (Map.Entry entry : this.dataLongMap.entrySet()) {
                text = text.replace("?" + (String)entry.getKey() + "?", Long.toString((Long)entry.getValue()));
            }
            for (Map.Entry entry : this.dataStringMap.entrySet()) {
                text = text.replace("?" + (String)entry.getKey() + "?", I18n.m_118938_((String)((String)entry.getValue()), (Object[])new Object[0]));
            }
        }
        return text;
    }

    public String getFilename() {
        return this.filename;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public ArrayList<QuestMarker> getMarkers() {
        return this.markers;
    }

    public QuestColor getColor() {
        if (this.isSpecialColor() && this.color.getR() == -1) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            long mod = world.m_46468_() % 120L;
            if (mod > 60L) {
                mod -= (mod - 60L) * 2L;
            }
            mod = (int)((double)mod * 1.7);
            return new QuestColor(28, 65 + (int)mod, 138);
        }
        return this.color;
    }

    public boolean isSpecialColor() {
        return this.specialColor;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public int getWeight() {
        return this.weight;
    }

    public StageIcon getIcon() {
        return this.icon;
    }

    public boolean isReadyForTurnIn() {
        return this.readyForTurnIn;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getName() {
        String name = this.format(this.name);
        return name == null || name.isEmpty() ? null : name;
    }

    public ArrayList<ObjectiveDetail> getObjectives() {
        return this.objectives;
    }

    public String getDesc() {
        return this.format(this.desc);
    }

    public void update() {
        QuestDataClient.getInstance().update(this.filename, this);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        super.read(buf);
    }

    @Override
    public void write(QuestProgress progress, FriendlyByteBuf buf) {
        super.write(progress, buf);
    }
}

