/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client;

import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.ui.GuiQuests;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class QuestDataClient {
    private static final QuestDataClient INSTANCE = new QuestDataClient();
    private final LinkedHashMap<String, QuestProgressClient> quests = new LinkedHashMap();
    private final LinkedHashMap<String, QuestProgressClient> completeQuests = new LinkedHashMap();
    private int displayQuest = -1;

    public static QuestDataClient getInstance() {
        return INSTANCE;
    }

    private QuestDataClient() {
    }

    public QuestProgressClient getDisplayQuest() {
        if (this.displayQuest >= this.quests.size()) {
            this.displayQuest = 0;
        }
        int i = 0;
        for (QuestProgressClient qpc : this.quests.values()) {
            if (this.displayQuest == i) {
                return qpc;
            }
            ++i;
        }
        return null;
    }

    public void setDisplayQuest(QuestProgressClient qpcIn) {
        if (qpcIn == null) {
            this.displayQuest = -1;
            return;
        }
        int i = 0;
        for (QuestProgressClient qpc : this.quests.values()) {
            if (qpc == qpcIn) {
                this.displayQuest = i;
                return;
            }
            ++i;
        }
    }

    public void cycleDisplayQuest() {
        boolean next = false;
        int i = 0;
        for (QuestProgressClient qpc : QuestDataClient.getInstance().getQuests()) {
            if (qpc.getName() != null) {
                if (this.displayQuest == -1) {
                    this.displayQuest = i;
                    return;
                }
                if (i == this.displayQuest) {
                    next = true;
                    ++i;
                    continue;
                }
                if (next) {
                    this.displayQuest = i;
                    return;
                }
            }
            ++i;
        }
        this.displayQuest = -1;
    }

    public void clear() {
        this.quests.clear();
        this.completeQuests.clear();
    }

    public void update(String filename, QuestProgressClient quest) {
        Screen screen;
        if (filename != null && !filename.isEmpty()) {
            if (quest.isComplete()) {
                this.quests.remove(filename);
                this.completeQuests.put(filename, quest);
            } else {
                this.quests.put(filename, quest);
            }
        }
        if ((screen = Minecraft.m_91087_().f_91080_) instanceof GuiQuests) {
            GuiQuests questsGUI = (GuiQuests)screen;
            questsGUI.refreshQuests();
        }
    }

    public void remove(String key) {
        this.quests.remove(key);
    }

    public QuestProgressClient get(UUID uuid) {
        for (QuestProgressClient qpc : this.getQuests()) {
            if (!uuid.equals(qpc.getIdentifier())) continue;
            return qpc;
        }
        for (QuestProgressClient qpc : this.getCompleteQuests()) {
            if (!uuid.equals(qpc.getIdentifier())) continue;
            return qpc;
        }
        return null;
    }

    public QuestProgressClient getVisible(UUID uuid) {
        for (QuestProgressClient qpc : this.getQuests()) {
            if (!uuid.equals(qpc.getIdentifier()) || qpc.isComplete() || !qpc.visible) continue;
            return qpc;
        }
        return null;
    }

    public Collection<QuestProgressClient> getQuests() {
        return this.quests.values();
    }

    public Collection<QuestProgressClient> getCompleteQuests() {
        return this.completeQuests.values();
    }
}

