/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class GiveItemAction
implements IAction {
    @Override
    public String identifier() {
        return "ITEM_GIVE";
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.ACTION, this.identifier(), new QuestElementArgument("item", false, false, ArgumentType.ITEM, new String[0]), new QuestElementArgument("count", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("damage_metadata", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("display_name", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("lore", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("nbt", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("has_effect", true, false, ArgumentType.BOOLEAN, new String[0]), new QuestElementArgument("flags", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("hide_tooltip", true, false, ArgumentType.BOOLEAN, new String[0]));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(s))), Argument.from(args.get(1), Integer::parseInt, 1), Argument.from(args.get(2), Integer::parseInt, -1), Argument.from(args.get(3), TextHelper::format, null), Argument.from(args.get(4), s -> TextHelper.format(s.replace("_", " ")).split("\n"), null), Argument.from(args.get(5), s -> {
            try {
                return TagParser.m_129359_((String)s);
            }
            catch (Exception e) {
                return null;
            }
        }, null), Argument.from(args.get(6), Boolean::parseBoolean, false), Argument.from(args.get(7), Integer::parseInt, -1), Argument.from(args.get(8), Boolean::parseBoolean, false));
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Arguments arguments) {
        ServerPlayer player;
        Item item = (Item)arguments.value(0, progress);
        int count = (Integer)arguments.value(1, progress);
        int damage = (Integer)arguments.value(2, progress);
        String name = (String)arguments.value(3, progress);
        String[] lore = (String[])arguments.value(4, progress);
        CompoundTag nbt = (CompoundTag)arguments.value(5, progress);
        boolean hasEffect = (Boolean)arguments.value(6, progress);
        int flags = (Integer)arguments.value(7, progress);
        boolean hideTooltip = (Boolean)arguments.value(8, progress);
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (damage >= 0) {
            stack.m_41721_(damage);
        }
        if (name != null) {
            stack.m_41714_((Component)Component.m_237113_((String)name));
        }
        if (lore != null) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            ListTag tags = new ListTag();
            for (String line : lore) {
                tags.add((Object)StringTag.m_129297_((String)line));
            }
            stack.m_41698_("display").m_128365_("Lore", (Tag)tags);
        }
        if (nbt != null) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128391_(nbt);
        }
        if (hideTooltip) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128359_("tooltip", "");
        }
        if (flags >= 0) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128405_("HideFlags", flags);
        }
        if (hasEffect) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128379_("HasEffect", true);
        }
        if (!(player = data.getPlayer()).m_36356_(stack)) {
            player.m_36176_(stack, true);
        }
    }
}

