/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.quests.FinishQuestEvent;
import com.pixelmonmod.pixelmon.api.events.quests.QuestObjectiveEvent;
import com.pixelmonmod.pixelmon.api.events.quests.QuestStageEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.comm.SendQuestDataPacket;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.DialogueInjectObjective;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Event;

public class QuestProgress
implements ISaveData {
    private short stage;
    private HashMap<String, Long> data1;
    private HashMap<String, String> data2;
    private int[] objectiveCompletion;
    private int[] objectiveCompletionReference;
    private boolean started;
    private boolean complete;
    private boolean failed;
    private Boolean abandonable = null;
    private String questFilename;
    private UUID identifier;
    private QuestData parent;
    private transient Quest quest = null;

    public QuestProgress(Quest quest, QuestData parent) {
        this.questFilename = quest.getFilename();
        this.identifier = UUID.randomUUID();
        this.stage = 0;
        this.data1 = new HashMap();
        this.data2 = new HashMap();
        this.initQuantities();
        this.started = false;
        this.complete = false;
        this.failed = false;
        this.abandonable = quest.isAbandonable();
        this.parent = parent;
    }

    public void start() {
        this.started = true;
    }

    public void fail(ServerPlayer player) {
        Pixelmon.EVENT_BUS.post((Event)new FinishQuestEvent.Fail(player, this));
        this.failed = true;
        this.stage = 0;
        this.data1.clear();
        this.data2.clear();
        this.complete(player);
        this.initQuantities();
    }

    public void complete(ServerPlayer player) {
        Pixelmon.EVENT_BUS.post((Event)new FinishQuestEvent.Complete(player, this));
        this.complete = true;
        this.objectiveCompletion = new int[0];
        this.objectiveCompletionReference = new int[0];
        this.sendTo(player);
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isComplete() {
        return this.complete && !this.failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void initQuantities() {
        Stage stage = this.getCurrentStage();
        if (stage != null) {
            int size = stage.getParsedObjectives().size();
            this.objectiveCompletion = new int[size];
            this.objectiveCompletionReference = new int[size];
            for (int i = 0; i < this.objectiveCompletion.length; ++i) {
                Objective objective = stage.getParsedObjectives().get(i);
                this.objectiveCompletion[i] = objective.getQuantity(stage, this.parent, this, objective, objective.getData());
                this.objectiveCompletionReference[i] = this.objectiveCompletion[i];
            }
        }
    }

    public void reopen() {
        this.complete = false;
        this.failed = false;
    }

    public Long getDataLong(String key) {
        return this.data1.getOrDefault(key, null);
    }

    public String getDataString(String key) {
        return this.data2.getOrDefault(key, null);
    }

    public String getData(String key) {
        Long l;
        String s = this.getDataString(key);
        if (s == null && (l = this.getDataLong(key)) != null) {
            s = String.valueOf(l);
        }
        return s;
    }

    public HashMap<String, Long> getDataLongMap() {
        return this.data1;
    }

    public HashMap<String, String> getDataStringMap() {
        return this.data2;
    }

    public ArrayList<UUID> getDataUUIDs() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String str : this.data2.values()) {
            try {
                uuids.add(UUID.fromString(str));
            }
            catch (Exception exception) {}
        }
        return uuids;
    }

    public void setData(String key, long value) {
        this.data1.put(key, value);
    }

    public void setData(String key, String value) {
        this.data2.put(key, value);
    }

    public void sendTo(ServerPlayer player) {
        if (player != null) {
            NetworkHelper.sendPacket(new SendQuestDataPacket(this), player);
        }
    }

    public short getStage() {
        return this.stage;
    }

    public Stage getCurrentStage() {
        return this.getQuest().getStage(this);
    }

    public Stage getNextStage() {
        return this.getQuest().getNextStage(this.stage);
    }

    public boolean setStage(short stage) {
        short prevStage = this.stage;
        this.stage = stage;
        Stage s = this.getQuest().getStage(this);
        if (s == null || s.getParsedObjectives() == null) {
            this.stage = prevStage;
            Pixelmon.EVENT_BUS.post((Event)new QuestStageEvent.Set(this.parent.getPlayer(), this, this.getCurrentStage(), true));
            return false;
        }
        int objArrSize = s.getParsedObjectives().size();
        this.objectiveCompletion = new int[objArrSize];
        this.objectiveCompletionReference = new int[objArrSize];
        for (int i = 0; i < this.objectiveCompletion.length; ++i) {
            Objective objective = s.getParsedObjectives().get(i);
            this.objectiveCompletion[i] = objective.getQuantity(s, this.parent, this, objective, objective.getData());
            this.objectiveCompletionReference[i] = this.objectiveCompletion[i];
        }
        Pixelmon.EVENT_BUS.post((Event)new QuestStageEvent.Set(this.parent.getPlayer(), this, this.getCurrentStage(), false));
        return true;
    }

    private boolean tryDialogueContinuity(QuestData quest, Stage oldStage, Stage newStage) throws InvalidQuestArgsException {
        if (oldStage == null || newStage == null) {
            return false;
        }
        Objective oldObjA = null;
        Objective newObjA = null;
        DialogueInjectObjective oldObjB = null;
        DialogueInjectObjective newObjB = null;
        for (Objective oldObjTest : oldStage.getParsedObjectives()) {
            if (!(oldObjTest.getInternalObjective() instanceof DialogueInjectObjective)) continue;
            oldObjA = oldObjTest;
            oldObjB = (DialogueInjectObjective)oldObjTest.getInternalObjective();
            break;
        }
        for (Objective newObjTest : newStage.getParsedObjectives()) {
            if (!(newObjTest.getInternalObjective() instanceof DialogueInjectObjective)) continue;
            newObjA = newObjTest;
            newObjB = (DialogueInjectObjective)newObjTest.getInternalObjective();
            break;
        }
        if (oldObjA == null || newObjA == null || oldObjB == null || newObjB == null) {
            return false;
        }
        UUID oldUUID = (UUID)oldObjA.getData().value(0, this);
        UUID newUUID = (UUID)newObjA.getData().value(0, this);
        if (oldUUID != null && oldUUID.equals(newUUID)) {
            newObjB.test(newStage, quest, this, newObjA, newObjA.getData(), new Context(new Object[]{quest.getPlayer().m_284548_().m_8791_(newUUID)}));
            return true;
        }
        return false;
    }

    public boolean moveStage(QuestData quest, Stage oldStage, short newStageID) throws InvalidQuestArgsException {
        this.setStage(newStageID);
        Stage newStage = this.getCurrentStage();
        return this.tryDialogueContinuity(quest, oldStage, newStage);
    }

    public void completeObjective(int index) {
        Stage stage = this.getCurrentStage();
        if (index >= this.objectiveCompletion.length) {
            return;
        }
        QuestObjectiveEvent.Progress event = new QuestObjectiveEvent.Progress(this.parent.getPlayer(), this, stage, stage.getParsedObjectives().get(index), index, this.objectiveCompletion[index]);
        Pixelmon.EVENT_BUS.post((Event)event);
        this.objectiveCompletion[index] = event.completion;
        if (this.objectiveCompletion[index] > 0) {
            int n = index;
            this.objectiveCompletion[n] = this.objectiveCompletion[n] - 1;
        }
    }

    public void resetObjective(int index) {
        if (index >= this.objectiveCompletion.length) {
            return;
        }
        this.objectiveCompletion[index] = 1;
    }

    public boolean isObjectiveComplete(int index) {
        if (index >= this.objectiveCompletion.length) {
            return false;
        }
        return this.objectiveCompletion[index] == 0;
    }

    public int getObjectiveQuantityComplete(int index) {
        if (index >= this.objectiveCompletion.length) {
            return 0;
        }
        return this.objectiveCompletionReference[index] - this.objectiveCompletion[index];
    }

    public int getObjectiveTotalQuantity(int index) {
        if (index >= this.objectiveCompletion.length) {
            return 0;
        }
        return this.objectiveCompletionReference[index];
    }

    public boolean canProgress() {
        for (int i : this.objectiveCompletion) {
            if (i <= 0) continue;
            return false;
        }
        return true;
    }

    public QuestMarker.Type getMarkerType() {
        return this.getNextStage() == null ? QuestMarker.Type.QUESTION : QuestMarker.Type.EXCLAMATION;
    }

    public ArrayList<QuestMarker> getMarkers() {
        Stage stage = this.getCurrentStage();
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        int i = 0;
        for (Objective objective : stage.getParsedObjectives()) {
            markers.addAll(objective.mark(stage, this, i++, objective.getData()));
        }
        return markers;
    }

    public String getQuestFilename() {
        return this.questFilename;
    }

    public Quest getQuest() {
        if (this.quest == null) {
            for (Quest quest : QuestRegistry.getInstance().getQuestCollection()) {
                if (!quest.getFilename().equals(this.getQuestFilename())) continue;
                this.quest = quest;
                break;
            }
        }
        return this.quest;
    }

    public void invalidate() {
        this.quest = null;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public boolean isAbandonable() {
        if (this.abandonable == null) {
            this.abandonable = this.getQuest().isAbandonable();
        }
        return this.abandonable;
    }

    public void setAbandonable(boolean abandonable) {
        this.abandonable = abandonable;
    }

    public QuestProgress(CompoundTag nbt, QuestData data) {
        this.readFromNBT(nbt);
        this.parent = data;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128376_("QuestStage", this.stage);
        ListTag data1TagList = new ListTag();
        for (Map.Entry<String, Long> entry : this.data1.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("QuestDataKey", entry.getKey());
            compoundTag.m_128356_("QuestDataValue", entry.getValue().longValue());
            data1TagList.add((Object)compoundTag);
        }
        nbt.m_128365_("QuestData1", (Tag)data1TagList);
        ListTag data2TagList = new ListTag();
        for (Map.Entry<String, String> entry : this.data2.entrySet()) {
            CompoundTag kvPair = new CompoundTag();
            kvPair.m_128359_("QuestDataKey", entry.getKey());
            kvPair.m_128359_("QuestDataValue", entry.getValue());
            data2TagList.add((Object)kvPair);
        }
        nbt.m_128365_("QuestData2", (Tag)data2TagList);
        nbt.m_128379_("QuestStarted", this.started);
        nbt.m_128379_("QuestComplete", this.complete);
        nbt.m_128379_("QuestFailed", this.failed);
        nbt.m_128379_("QuestAbandonable", this.isAbandonable());
        if (this.objectiveCompletion == null) {
            void var4_7;
            this.objectiveCompletion = new int[this.getCurrentStage().getParsedObjectives().size()];
            boolean bl = false;
            while (var4_7 < this.objectiveCompletion.length) {
                Objective objective = this.getCurrentStage().getParsedObjectives().get((int)var4_7);
                this.objectiveCompletion[var4_7] = objective.getQuantity(this.getCurrentStage(), this.parent, this, objective, objective.getData());
                ++var4_7;
            }
        }
        int[] nArray = new int[this.objectiveCompletion.length];
        System.arraycopy(this.objectiveCompletion, 0, nArray, 0, nArray.length);
        nbt.m_128385_("QuestCompletion", nArray);
        int[] nArray2 = new int[this.objectiveCompletionReference.length];
        System.arraycopy(this.objectiveCompletionReference, 0, nArray2, 0, nArray2.length);
        nbt.m_128385_("QuestCompletionRef", nArray2);
        nbt.m_128359_("QuestFilename", this.questFilename);
        nbt.m_128362_("QuestIdentifier", this.identifier);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        CompoundTag kvPair;
        int i;
        ListTag list;
        this.questFilename = nbt.m_128461_("QuestFilename");
        this.identifier = nbt.m_128342_("QuestIdentifier");
        this.stage = nbt.m_128448_("QuestStage");
        if (this.data1 == null) {
            this.data1 = new HashMap();
        } else {
            this.data1.clear();
        }
        if (nbt.m_128441_("QuestData1")) {
            list = nbt.m_128437_("QuestData1", 10);
            for (i = 0; i < list.size(); ++i) {
                kvPair = (CompoundTag)list.get(i);
                this.data1.put(kvPair.m_128461_("QuestDataKey"), kvPair.m_128454_("QuestDataValue"));
            }
        }
        if (this.data2 == null) {
            this.data2 = new HashMap();
        } else {
            this.data2.clear();
        }
        if (nbt.m_128441_("QuestData2")) {
            list = nbt.m_128437_("QuestData2", 10);
            for (i = 0; i < list.size(); ++i) {
                kvPair = (CompoundTag)list.get(i);
                this.data2.put(kvPair.m_128461_("QuestDataKey"), kvPair.m_128461_("QuestDataValue"));
            }
        }
        this.started = nbt.m_128471_("QuestStarted");
        this.complete = nbt.m_128471_("QuestComplete");
        this.failed = nbt.m_128471_("QuestFailed");
        this.abandonable = nbt.m_128441_("QuestAbandonable") ? Boolean.valueOf(nbt.m_128471_("QuestAbandonable")) : Boolean.valueOf(this.getQuest().isAbandonable());
        int objectivesLen = this.getCurrentStage().getParsedObjectives().size();
        this.objectiveCompletion = new int[objectivesLen];
        this.objectiveCompletionReference = new int[objectivesLen];
        int[] loadedObjectiveCompletion = nbt.m_128465_("QuestCompletion");
        int[] loadedObjectiveCompletionReference = nbt.m_128465_("QuestCompletionRef");
        if (loadedObjectiveCompletion.length != objectivesLen || loadedObjectiveCompletionReference.length != objectivesLen) {
            Pixelmon.LOGGER.warn("Found invalid objective progress data in an instance of quest " + this.getQuestFilename() + ", resetting that instance!");
            for (int i2 = 0; i2 < objectivesLen; ++i2) {
                Objective objective = this.getCurrentStage().getParsedObjectives().get(i2);
                this.objectiveCompletion[i2] = objective.getQuantity(this.getCurrentStage(), this.parent, this, objective, objective.getData());
                this.objectiveCompletionReference[i2] = this.objectiveCompletion[i2];
            }
        } else {
            int i3 = 0;
            for (int value : loadedObjectiveCompletion) {
                if (i3 >= this.objectiveCompletion.length) break;
                this.objectiveCompletion[i3++] = (short)value;
            }
            int j = 0;
            for (int value : loadedObjectiveCompletionReference) {
                if (j < this.objectiveCompletionReference.length) {
                    this.objectiveCompletionReference[j++] = (short)value;
                    continue;
                }
                break;
            }
        }
    }

    public QuestData getParent() {
        return this.parent;
    }
}

