/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.ZygardeCellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import com.pixelmonmod.pixelmon.blocks.ultraspace.LogBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="pixelmon")
public class ZygardeCellsListener {
    private static final boolean DEBUG = false;
    private static final TagKey<Block> SPAWNABLE_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("pixelmon", "zygarde_spawnable"));
    private static final Direction[] ALL_DIRECTIONS_BUT_UP = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Direction[] DIRECTIONS_LOGS_X = new Direction[]{Direction.DOWN, Direction.WEST, Direction.EAST, Direction.UP};
    private static final Direction[] DIRECTIONS_LOGS_Z = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.UP};
    private static final Direction[] DIRECTIONS_LOGS_Y = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final int HALF_HOUR_IN_TICKS = 36000;
    private static final Set<UUID> hasCube = Sets.newHashSet();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_5833_()) {
            return;
        }
        if (ZygardeCellsListener.checkForCube(event.getEntity())) {
            hasCube.add(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        hasCube.remove(event.getEntity().m_20148_());
    }

    public static boolean hasCube(Player player) {
        return hasCube.contains(player.m_20148_());
    }

    public static boolean checkForCube(@Nonnull Player player) {
        Inventory inv = player.m_150109_();
        Predicate<ItemStack> check = itemStack -> itemStack.m_41720_() == PixelmonItems.zygarde_cube;
        return inv.f_35974_.stream().anyMatch(check) || inv.f_35976_.stream().anyMatch(check);
    }

    public static void trySpawnInChunk(ServerPlayer player, ChunkAccess chunk) {
        int x = RandomHelper.getRandomNumberBetween(1, 14);
        int z = RandomHelper.getRandomNumberBetween(1, 14);
        int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        if (!BlockHelper.findAllTileEntityWithinRange(ZygardeCellTileEntity.class, player.f_19853_, Vec3.m_82512_((Vec3i)chunk.m_7697_().m_45615_().m_7918_(x, y, z)), 72.0, null).isEmpty()) {
            return;
        }
        List<Pair<BlockState, BlockPos>> list = ZygardeCellsListener.scanArea(chunk, x, y, z);
        if (list.isEmpty()) {
            return;
        }
        Collections.shuffle(list);
        for (Pair<BlockState, BlockPos> pair : list) {
            Direction[] directions;
            BlockState state = (BlockState)pair.getKey();
            BlockPos pos = (BlockPos)pair.getValue();
            Direction facing = ZygardeCellsListener.hasAirPocket(chunk, pos, directions = ZygardeCellsListener.getDirectionsForBlock(state));
            if (facing == null) continue;
            ZygardeCellsListener.spawnOn(chunk, pos.m_121945_(facing), facing.m_122424_(), player);
            return;
        }
    }

    private static List<Pair<BlockState, BlockPos>> scanArea(ChunkAccess chunk, int x, int y, int z) {
        ArrayList<Pair<BlockState, BlockPos>> list = new ArrayList<Pair<BlockState, BlockPos>>();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, y, z);
        int startX = mPos.m_123341_() + 1;
        int startY = mPos.m_123342_() + 120 - y;
        int startZ = mPos.m_123343_() + 1;
        int endX = mPos.m_123341_() - 1;
        int endY = mPos.m_123342_() - 1;
        int endZ = mPos.m_123343_() - 1;
        for (int lx = startX; lx >= endX; --lx) {
            for (int ly = startY; ly >= endY; --ly) {
                if (list.size() > 12) {
                    return list;
                }
                for (int lz = startZ; lz >= endZ; --lz) {
                    mPos.m_122178_(lx, ly, lz);
                    BlockState state = chunk.m_8055_((BlockPos)mPos);
                    if (!ZygardeCellsListener.canSpawnOn(state)) continue;
                    list.add((Pair<BlockState, BlockPos>)Pair.of((Object)state, (Object)mPos.m_7949_()));
                }
            }
        }
        return list;
    }

    private static boolean canSpawnOn(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61447_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61447_)).booleanValue()) {
            return false;
        }
        return state.m_204336_(SPAWNABLE_TAG);
    }

    private static Direction[] getDirectionsForBlock(BlockState state) {
        if (state.m_204336_(BlockTags.f_13035_) || state.m_60713_(Blocks.f_50440_) || state.m_60734_() instanceof LeavesBlock || state.m_60734_() instanceof GrassBlock) {
            return ALL_DIRECTIONS_BUT_UP;
        }
        if (state.m_60734_() instanceof LogBlock && state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            if (state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X) {
                return DIRECTIONS_LOGS_X;
            }
            if (state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Z) {
                return DIRECTIONS_LOGS_Z;
            }
            return DIRECTIONS_LOGS_Y;
        }
        return ALL_DIRECTIONS_BUT_UP;
    }

    private static Direction hasAirPocket(ChunkAccess chunk, BlockPos pos, Direction ... facings) {
        ArrayList facingList = Lists.newArrayList();
        for (Direction facing : facings) {
            BlockPos offset = pos.m_121945_(facing);
            if (!chunk.m_8055_(offset).m_60795_()) continue;
            facingList.add(facing);
        }
        return (Direction)RandomHelper.getRandomElementFromList(facingList);
    }

    private static void spawnOn(ChunkAccess chunk, BlockPos pos, Direction facing, ServerPlayer player) {
        Direction rotation = facing.m_122434_() == Direction.Axis.Y ? Direction.Plane.HORIZONTAL.m_235690_(RandomSource.m_216327_()) : (RandomHelper.getRandomChance() ? Direction.UP : Direction.DOWN);
        Block block = RandomHelper.getRandomChance(5) ? PixelmonBlocks.zygarde_core : PixelmonBlocks.zygarde_cell;
        BlockState state = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)ZygardeCellBlock.ORIENTATION_PROPERTY, (Comparable)facing)).m_61124_((Property)ZygardeCellBlock.ROTATION_PROPERTY, (Comparable)rotation);
        BlockPos abPos = chunk.m_7697_().m_45615_().m_121955_((Vec3i)pos);
        chunk.getWorldForge().m_7731_(abPos, state, 0);
    }

    private static /* synthetic */ Style lambda$spawnOn$3(BlockPos abPos, Style it) {
        return it.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + abPos.m_123341_() + " " + abPos.m_123342_() + " " + abPos.m_123343_()));
    }

    static {
        Scheduling.schedule(100, task -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            hasCube.clear();
            if (server != null && server.m_130010_()) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    if (player.m_5833_()) {
                        return;
                    }
                    if (!ZygardeCellsListener.checkForCube((Player)player)) continue;
                    hasCube.add(player.m_20148_());
                }
            }
        }, true);
        Scheduling.schedule(200, task -> {
            if (!PixelmonConfigProxy.getSpawning().isSpawnZygardeCells()) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && server.m_130010_()) {
                if (hasCube.isEmpty()) {
                    return;
                }
                UUID random = RandomHelper.getRandomElementFromList(hasCube);
                ServerPlayer player = server.m_6846_().m_11259_(random);
                if (player.m_5833_()) {
                    return;
                }
                ArrayList chunks = Lists.newArrayList();
                int distance = server.m_6846_().m_11312_();
                int x1 = player.m_146902_().f_45578_ + distance;
                int z1 = player.m_146902_().f_45579_ + distance;
                int x2 = player.m_146902_().f_45578_ - distance;
                int z2 = player.m_146902_().f_45579_ - distance;
                for (int x = x1; x >= x2; --x) {
                    for (int z = z1; z >= z2; --z) {
                        LevelChunk chunk;
                        if (x >= player.m_146902_().f_45578_ - 1 && x <= player.m_146902_().f_45578_ + 1 && z >= player.m_146902_().f_45579_ - 1 && z <= player.m_146902_().f_45579_ + 1 || (chunk = player.m_9236_().m_7726_().m_7131_(x, z)) == null || chunk.m_6319_() >= 36000L) continue;
                        chunks.add(chunk);
                    }
                }
                if (!chunks.isEmpty()) {
                    ZygardeCellsListener.trySpawnInChunk(player, (ChunkAccess)RandomHelper.getRandomElementFromList(chunks));
                }
            }
        }, true);
    }
}

