/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VillageListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCreateSpawnPosition(LevelEvent.CreateSpawnPosition event) {
        if (VillageListener.setVillageSpawnPoint((ServerLevel)event.getLevel(), event.getSettings())) {
            event.setCanceled(true);
        }
    }

    private static boolean setVillageSpawnPoint(ServerLevel world, ServerLevelData worldInfo) {
        if (!PixelmonConfigProxy.getStructures().shouldAlwaysSpawnInVillage()) {
            return false;
        }
        boolean bonusChest = ServerLifecycleHooks.getCurrentServer().m_129910_().m_246337_().m_245100_();
        ServerChunkCache chunkSource = world.m_7726_();
        ChunkPos chunkpos = new ChunkPos(chunkSource.m_214994_().m_224579_().m_183230_());
        BlockPos villageblockpos = world.m_215011_(StructureTags.f_215889_, chunkpos.m_45615_().m_7918_(0, world.m_5736_(), 0), 100, false);
        if (villageblockpos == null) {
            Pixelmon.LOGGER.warn("Unable to find spawn village");
        } else {
            chunkpos = new ChunkPos(villageblockpos);
        }
        int i = chunkSource.m_8481_().m_142051_((LevelHeightAccessor)world);
        if (i < world.m_141937_()) {
            BlockPos blockpos = chunkpos.m_45615_();
            i = world.m_6924_(Heightmap.Types.WORLD_SURFACE, blockpos.m_123341_() + 8, blockpos.m_123343_() + 8);
        }
        worldInfo.m_7250_(chunkpos.m_45615_().m_7918_(8, i, 8), 0.0f);
        int k1 = 0;
        int j = 0;
        int k = 0;
        int l = -1;
        int i1 = 5;
        for (int j1 = 0; j1 < Mth.m_144944_((int)11); ++j1) {
            BlockPos blockpos1;
            if (k1 >= -5 && k1 <= 5 && j >= -5 && j <= 5 && (blockpos1 = PlayerRespawnLogic.m_183932_((ServerLevel)world, (ChunkPos)new ChunkPos(chunkpos.f_45578_ + k1, chunkpos.f_45579_ + j))) != null) {
                worldInfo.m_7250_(blockpos1, 0.0f);
                break;
            }
            if (k1 == j || k1 < 0 && k1 == -j || k1 > 0 && k1 == 1 - j) {
                int l1 = k;
                k = -l;
                l = l1;
            }
            k1 += k;
            j += l;
        }
        if (bonusChest) {
            world.m_9598_().m_6632_(Registries.f_256911_).flatMap(p_258226_ -> p_258226_.m_203636_(MiscOverworldFeatures.f_195021_)).ifPresent(p_264729_ -> ((ConfiguredFeature)p_264729_.m_203334_()).m_224953_((WorldGenLevel)world, chunkSource.m_8481_(), RandomSource.m_216327_(), new BlockPos(worldInfo.m_6789_(), worldInfo.m_6527_(), worldInfo.m_6526_())));
        }
        return true;
    }
}

