/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpinListener {
    private static final Map<UUID, SpinData> workmap = new HashMap<UUID, SpinData>();

    public static void registerListener(Player player, Consumer<Player> consumer) {
        if (workmap.isEmpty()) {
            MinecraftForge.EVENT_BUS.register(SpinListener.class);
        }
        workmap.put(player.m_20148_(), new SpinData(player, consumer));
    }

    @SubscribeEvent
    public static void onPlayerSpin(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (workmap.containsKey(player.m_20148_())) {
            SpinData data = workmap.get(player.m_20148_());
            boolean completed = false;
            if (player.m_6350_() != data.lastFacing) {
                if (data.lastFacing == data.startFacing) {
                    data.forward = data.lastFacing.m_122427_() == player.m_6350_();
                    data.lastFacing = player.m_6350_();
                } else if (data.lastFacing.m_122427_() == player.m_6350_() && data.forward) {
                    if (data.startFacing == player.m_6350_()) {
                        completed = true;
                    }
                    data.lastFacing = player.m_6350_();
                } else if (data.lastFacing.m_122427_().m_122424_() == player.m_6350_() && !data.forward) {
                    if (data.startFacing == player.m_6350_()) {
                        completed = true;
                    }
                    data.lastFacing = player.m_6350_();
                } else {
                    data.reset(player);
                }
            }
            if (completed) {
                data.consumer.accept(player);
                workmap.remove(player.m_20148_());
                if (workmap.isEmpty()) {
                    MinecraftForge.EVENT_BUS.unregister(SpinListener.class);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        workmap.remove(event.getEntity().m_20148_());
        if (workmap.isEmpty()) {
            MinecraftForge.EVENT_BUS.unregister(SpinListener.class);
        }
    }

    private static class SpinData {
        Direction startFacing = null;
        Direction lastFacing = null;
        boolean forward = false;
        Consumer<Player> consumer;

        public SpinData(Player player, Consumer<Player> consumer) {
            this.reset(player);
            this.consumer = consumer;
        }

        public void reset(Player player) {
            this.startFacing = this.lastFacing = player.m_6350_();
        }

        public String toString() {
            return "SpinData{startFacing=" + this.startFacing + ", lastFacing=" + this.lastFacing + ", forward=" + this.forward + "}";
        }
    }
}

