/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.PokeBallImpactEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.entities.pokeballs.OccupiedPokeBallEntity;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RotomListener {
    private static BiMap<Block, String> blockMap = HashBiMap.create();
    private static BiMap<String, RegistryValue<ImmutableAttack>> attackMap = HashBiMap.create();

    public static BiMap<Block, String> getBlockImpactMap() {
        if (blockMap.isEmpty()) {
            blockMap.put((Object)Blocks.f_50094_, (Object)"heat");
            blockMap.put((Object)PixelmonBlocks.fridge, (Object)"frost");
            blockMap.put((Object)PixelmonBlocks.mower, (Object)"mow");
            blockMap.put((Object)PixelmonBlocks.washing_machine, (Object)"wash");
            blockMap.put((Object)PixelmonBlocks.fan, (Object)"fan");
        }
        return blockMap;
    }

    public static BiMap<String, RegistryValue<ImmutableAttack>> getAttackMap() {
        if (attackMap.isEmpty()) {
            attackMap.put((Object)PixelmonForms.NONE, AttackRegistry.THUNDER_SHOCK);
            attackMap.put((Object)"heat", AttackRegistry.OVERHEAT);
            attackMap.put((Object)"frost", AttackRegistry.BLIZZARD);
            attackMap.put((Object)"mow", AttackRegistry.LEAF_STORM);
            attackMap.put((Object)"wash", AttackRegistry.HYDRO_PUMP);
            attackMap.put((Object)"fan", AttackRegistry.AIR_SLASH);
        }
        return attackMap;
    }

    @SubscribeEvent
    public static void onRotomChangeForm(PokeBallImpactEvent event) {
        if (event.getPokeBall().f_19853_.f_46443_ || !event.getBlockHit().isPresent() || event.isEmptyPokeBall() || !(event.getPokeBall().m_19749_() instanceof ServerPlayer)) {
            return;
        }
        Species species = ((OccupiedPokeBallEntity)event.getPokeBall()).getPokemon().orElse(null);
        if (species == null || !species.is(PixelmonSpecies.ROTOM)) {
            return;
        }
        Block block = event.getBlockHit().get().m_60734_();
        if (!RotomListener.getBlockImpactMap().containsKey((Object)block)) {
            return;
        }
        String form = (String)RotomListener.getBlockImpactMap().get((Object)block);
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)event.getPokeBall().m_19749_());
        Pokemon pokemon = party.find(event.getPokeBall().getPokeUUID());
        if (pokemon == null) {
            return;
        }
        if (form.equalsIgnoreCase(pokemon.getForm().getName())) {
            form = PixelmonForms.NONE;
        }
        if (RotomListener.replaceMove(pokemon, pokemon.getForm().getName(), form)) {
            pokemon.setForm(form);
        } else {
            LearnMoveController.sendLearnMove(party.getPlayer(), pokemon.getUUID(), (ImmutableAttack)((RegistryValue)RotomListener.getAttackMap().get((Object)form)).get());
        }
    }

    public static void replacedMove(PokemonLink pixelmon, Attack attack) {
        String form = (String)RotomListener.getAttackMap().inverse().get(RegistryValue.of(ImmutableAttack.class, attack.getMove().getAttackName()));
        if (form == null) {
            return;
        }
        if (pixelmon instanceof DelegateLink) {
            pixelmon.getEntity().setForm(form);
        }
    }

    public static void replacedMove(Pokemon pokemon, Attack attack) {
        String form = (String)RotomListener.getAttackMap().inverse().get(Optional.of(attack.getMove()));
        if (form == null) {
            return;
        }
        pokemon.setForm(form);
    }

    private static boolean replaceMove(Pokemon pokemon, String from, String to) {
        int index = -1;
        RegistryValue fromAttack = (RegistryValue)RotomListener.getAttackMap().get((Object)from);
        for (int i = 0; i < 4; ++i) {
            Attack attack = pokemon.getMoveset().get(i);
            if (attack == null || !attack.isAttack(fromAttack)) continue;
            index = i;
        }
        if (index == -1) {
            return false;
        }
        pokemon.getMoveset().set(index, ((ImmutableAttack)((RegistryValue)RotomListener.getAttackMap().get((Object)to)).get()).ofMutable());
        return true;
    }
}

