/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleResults;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokerusEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.log.action.BattleAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.AttackAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PokerusSpreader {
    @SubscribeEvent
    public static void onBattleEnd(BattleEndEvent event) {
        if (!PixelmonConfigProxy.getGeneral().getPokerus().isEnabled() || PixelmonConfigProxy.getGeneral().getPokerus().getSpreadRate() < 0) {
            return;
        }
        if (!event.isAbnormal()) {
            ArrayList winners = new ArrayList();
            event.getResults().forEach((participant, result) -> {
                if (result == BattleResults.VICTORY && participant instanceof PlayerParticipant) {
                    PokerusSpreader.spreadToParty((PlayerParticipant)participant);
                    winners.add(((PlayerParticipant)participant).player.m_20148_());
                }
            });
            if (!winners.isEmpty()) {
                HashMap<UUID, List> analyzedMap = new HashMap<UUID, List>();
                for (BattleAction un1 : event.getBattleController().battleLog.getAllActions()) {
                    AttackAction attack;
                    if (!(un1 instanceof AttackAction) || (attack = (AttackAction)un1).getPokemon().getPokerus().isPresent() || !(attack.getPokemon().getParticipant() instanceof PlayerParticipant) || !winners.contains(((PlayerParticipant)attack.getPokemon().getParticipant()).player.m_20148_())) continue;
                    UUID receiver = attack.getPokemon().getPokemonUUID();
                    if (!analyzedMap.containsKey(receiver)) {
                        analyzedMap.put(receiver, new ArrayList());
                    }
                    for (MoveResults res : attack.getMoveResults()) {
                        if (res == null || res.target == null || !res.target.getPokerus().isPresent() || !res.result.isSuccess()) continue;
                        UUID donor = res.target.getPokemonUUID();
                        List donors = (List)analyzedMap.get(receiver);
                        if (donors.contains(donor)) continue;
                        donors.add(donor);
                        analyzedMap.put(receiver, donors);
                        res.target.getPokerus().ifPresent(pkrs -> PokerusSpreader.spread(pkrs.type, attack.getPokemon(), (PlayerPartyStorage)attack.getPokemon().getParticipant().getStorage()));
                    }
                }
            }
        }
    }

    private static void spreadToParty(PlayerParticipant participant) {
        PixelmonWrapper[] party = participant.allPokemon;
        for (int i = 0; i < party.length; ++i) {
            Pokerus pkrs;
            if (!party[i].isAlive() && !party[i].pokemon.isEgg() || (pkrs = (Pokerus)party[i].getPokerus().orElse(null)) == null) continue;
            if (i > 0) {
                PokerusSpreader.spread(pkrs.type, party[i - 1], participant.getStorage());
            }
            if (i + 1 >= party.length) continue;
            PokerusSpreader.spread(pkrs.type, party[i + 1], participant.getStorage());
        }
    }

    private static void spread(PokerusStrain donorType, PixelmonWrapper wrapper, PlayerPartyStorage storage) {
        if (wrapper.isFainted()) {
            return;
        }
        if (!(PixelmonConfigProxy.getGeneral().getPokerus().getSpreadRate() != 0 && RandomHelper.getRandom().nextInt(PixelmonConfigProxy.getGeneral().getPokerus().getSpreadRate()) != 0 || Pixelmon.EVENT_BUS.post((Event)new PokerusEvent.Spread.Pre(storage, wrapper, donorType)))) {
            if (wrapper.entity == null) {
                Pokemon pokemon = wrapper.pokemon;
                Pokerus pokerus = new Pokerus(donorType);
                pokemon.setPokerus(pokerus);
            } else {
                PixelmonEntity receiver = wrapper.entity;
                receiver.getPokemon().setPokerus(new Pokerus(donorType));
                receiver.update(EnumUpdateType.Pokerus);
            }
            Pixelmon.EVENT_BUS.post((Event)new PokerusEvent.Spread.Post(storage, wrapper, donorType));
        }
    }
}

