/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ServerConfigListPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ServerCosmeticsUpdatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateClientRulesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.SetTempMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.SendEntireDayCarePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PixelmonPlayerTracker {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        NetworkHelper.sendPacket(new ServerConfigListPacket(), (ServerPlayer)event.getEntity());
        StorageProxy.getParty(player).whenComplete((party, throwable) -> {
            NetworkHelper.sendPacket(new ServerCosmeticsUpdatePacket(party.getServerCosmetics()), player);
            party.playerPokedex.checkForCharms();
            NetworkHelper.sendPacket(new SetTempMode(party.inTemporaryMode(), party.getTempPartyColor()), player);
            for (int i = 0; i < 6; ++i) {
                party.notifyListeners(new StoragePosition(-1, i), party.get(i), EnumUpdateType.CLIENT);
            }
            NetworkHelper.sendPacket(new SendEntireDayCarePacket(party.getDayCare()), player);
            PixelmonPlayerTracker.removePlayer(player);
            if (PixelmonConfigProxy.getGeneral().isAlwaysHaveMegaRing()) {
                try {
                    if (!party.getMegaItemsUnlocked().canMega()) {
                        party.setMegaItem(EnumMegaItem.BraceletORAS, false);
                        party.unlockMega(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (PixelmonConfigProxy.getGeneral().isAlwaysHaveDynamaxBand()) {
                try {
                    if (!party.getMegaItemsUnlocked().canDynamax()) {
                        party.setMegaItem(EnumMegaItem.DynamaxBand, false);
                        party.unlockDynamax(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BankAccountProxy.getBankAccountNow(player).updatePlayer();
            NetworkHelper.sendPacket(new UpdateClientPlayerDataPacket(party.trainerCardColor), player);
            party.playerPokedex.update();
            NetworkHelper.sendPacket(new UpdateClientRulesPacket(), player);
            PixelmonAdvancements.POKEDEX_TRIGGER.trigger(player);
        });
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            PixelmonPlayerTracker.removePlayer((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity eventEntity = event.getEntity();
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (!player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                StorageProxy.getPartyNow(player).dropLureInLureSlot(player);
            }
            PixelmonPlayerTracker.removePlayer((ServerPlayer)eventEntity);
        }
    }

    public static void removePlayer(ServerPlayer player) {
        EvolutionQuery eq;
        StorageProxy.getPartyNow(player).retrieveAll("Forced");
        BattleQuery bq = BattleQuery.getQuery(player);
        if (bq != null) {
            bq.declineQuery(player);
        }
        if ((eq = EvolutionQueryList.get((Player)player)) != null) {
            EvolutionQueryList.declineQuery(player, eq.pokemonUUID);
        }
        DropItemQueryList.removeQuery(player);
        BattleController bc = BattleRegistry.getBattle((Player)player);
        if (bc != null) {
            if (bc.hasSpectator((Player)player)) {
                bc.removeSpectator(player);
            } else {
                bc.endBattle(BattleEndCause.FORCE);
            }
        }
        LearnMoveController.clearLearnMoves(player);
        TeamSelectionRegistry.removeSelection(player);
        TickHandler.deregisterStarterList(player);
        NPCTrades.clearTradePair(player.m_20148_());
    }
}

