/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityPlayerExtension {
    public static EntityDataAccessor<String> dwPokeballs;
    public static EntityDataAccessor<Byte> dwMegaItem;
    public static EntityDataAccessor<Byte> dwMegaItemsUnlocked;
    public static EntityDataAccessor<Byte> dwShinyCharm;
    public static EntityDataAccessor<Byte> dwOvalCharm;
    public static EntityDataAccessor<Byte> dwExpCharm;
    public static EntityDataAccessor<Byte> dwCatchingCharm;
    public static EntityDataAccessor<Byte> dwMarkCharm;
    public static EntityDataAccessor<Byte> dwHween;

    public static boolean isDefined(Player player) {
        return player.m_20088_().m_135379_(dwPokeballs) != null && player.m_20088_().m_135379_(dwMegaItem) != null && player.m_20088_().m_135379_(dwMegaItemsUnlocked) != null && player.m_20088_().m_135379_(dwShinyCharm) != null && player.m_20088_().m_135379_(dwOvalCharm) != null && player.m_20088_().m_135379_(dwExpCharm) != null && player.m_20088_().m_135379_(dwCatchingCharm) != null && player.m_20088_().m_135379_(dwMarkCharm) != null && player.m_20088_().m_135379_(dwHween) != null;
    }

    @SubscribeEvent
    public static void handleConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof Player) {
            SynchedEntityData dw = event.getEntity().m_20088_();
            dw.m_135372_(dwPokeballs, (Object)",,,,,,");
            dw.m_135372_(dwMegaItem, (Object)0);
            dw.m_135372_(dwMegaItemsUnlocked, (Object)0);
            dw.m_135372_(dwShinyCharm, (Object)0);
            dw.m_135372_(dwOvalCharm, (Object)0);
            dw.m_135372_(dwExpCharm, (Object)0);
            dw.m_135372_(dwCatchingCharm, (Object)0);
            dw.m_135372_(dwMarkCharm, (Object)0);
            dw.m_135372_(dwHween, (Object)0);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            EntityPlayerExtension.resendAll((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            EntityPlayerExtension.resendAll((ServerPlayer)event.getEntity());
        }
    }

    private static void resendAll(ServerPlayer player) {
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        if (party != null) {
            EntityPlayerExtension.updatePlayerPokeballs(player, party.getAll());
            EntityPlayerExtension.updatePlayerMegaItem(player, party.getMegaItem());
            EntityPlayerExtension.updatePlayerMegaItemsUnlocked(player, party.getMegaItemsUnlocked());
            EntityPlayerExtension.updatePlayerOvalCharm(player, party.getOvalCharm());
            EntityPlayerExtension.updatePlayerShinyCharm(player, party.getShinyCharm());
            EntityPlayerExtension.updatePlayerHweenRobe(player, party.getHweenRobe());
        }
    }

    public static void updatePlayerPokeballs(ServerPlayer player, Pokemon[] pokemon) {
        if (player == null) {
            return;
        }
        StringBuilder ballsList = new StringBuilder();
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] != null && !pokemon[i].isEgg()) {
                ballsList.append(pokemon[i].getBall().getName()).append(",");
                continue;
            }
            ballsList.append(",");
        }
        player.m_20088_().m_135381_(dwPokeballs, (Object)ballsList.toString());
    }

    public static String[] getPlayerPokeballs(Player player) {
        String ballsList = (String)player.m_20088_().m_135370_(dwPokeballs);
        String[] splits = ballsList.split(",");
        String[] balls = new String[6];
        System.arraycopy(splits, 0, balls, 0, splits.length);
        return balls;
    }

    public static void updatePlayerMegaItem(ServerPlayer player, EnumMegaItem megaItem) {
        player.m_20088_().m_135381_(dwMegaItem, (Object)((byte)megaItem.ordinal()));
    }

    public static EnumMegaItem getPlayerMegaItem(Player player) {
        return EnumMegaItem.fromOrdinal(((Byte)player.m_20088_().m_135370_(dwMegaItem)).byteValue());
    }

    public static void updatePlayerMegaItemsUnlocked(ServerPlayer player, EnumMegaItemsUnlocked megaItemsUnlocked) {
        player.m_20088_().m_135381_(dwMegaItemsUnlocked, (Object)((byte)megaItemsUnlocked.ordinal()));
    }

    public static EnumMegaItemsUnlocked getPlayerMegaItemsUnlocked(Player player) {
        return EnumMegaItemsUnlocked.fromOrdinal(((Byte)player.m_20088_().m_135370_(dwMegaItemsUnlocked)).byteValue());
    }

    public static void updatePlayerShinyCharm(ServerPlayer player, EnumFeatureState charm) {
        player.m_20088_().m_135381_(dwShinyCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerShinyCharm(Player player) {
        return EnumFeatureState.values()[(Byte)player.m_20088_().m_135370_(dwShinyCharm)];
    }

    public static void updatePlayerOvalCharm(ServerPlayer player, EnumFeatureState charm) {
        player.m_20088_().m_135381_(dwOvalCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerOvalCharm(Player player) {
        return EnumFeatureState.values()[(Byte)player.m_20088_().m_135370_(dwOvalCharm)];
    }

    public static void updatePlayerHweenRobe(ServerPlayer player, EnumFeatureState charm) {
        player.m_20088_().m_135381_(dwHween, (Object)((byte)charm.ordinal()));
    }

    public static void updatePlayerExpCharm(ServerPlayer player, EnumFeatureState charm) {
        player.m_20088_().m_135381_(dwExpCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerExpCharm(Player player) {
        return EnumFeatureState.values()[(Byte)player.m_20088_().m_135370_(dwExpCharm)];
    }

    public static void updatePlayerCatchingCharm(ServerPlayer player, EnumFeatureState charm) {
        player.m_20088_().m_135381_(dwCatchingCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerCatchingCharm(Player player) {
        return EnumFeatureState.values()[(Byte)player.m_20088_().m_135370_(dwCatchingCharm)];
    }

    public static void updatePlayerMarkCharm(ServerPlayer player, EnumFeatureState charm) {
        player.m_20088_().m_135381_(dwMarkCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerMarkCharm(Player player) {
        return EnumFeatureState.values()[(Byte)player.m_20088_().m_135370_(dwMarkCharm)];
    }

    public static EnumFeatureState getPlayerHweenRobe(Player player) {
        return EnumFeatureState.values()[(Byte)player.m_20088_().m_135370_(dwHween)];
    }

    static {
        CommonHelper.disableLogMessage(SynchedEntityData.class, ".*EntityPlayerExtension.*");
        dwPokeballs = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        dwMegaItem = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwMegaItemsUnlocked = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwShinyCharm = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwOvalCharm = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwExpCharm = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwCatchingCharm = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwMarkCharm = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        dwHween = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    }
}

